<?php
/**
Plugin Name: SRS Simple hits Counter
Plugin URI: https://atif.rocks/srs-simple-hits-counter/
Description: This is a simple plugin to count and show a total number of hits (Unique visitors or page-views) to your WordPress website without using any third party code.
Author: Atif Rocks
Version: 2.1
Author URI: https://atif.rocks/
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

//create table
register_activation_hook(__FILE__, 'srs_hits_counter_installNewTables');
function srs_hits_counter_installNewTables() {
    global $wpdb;
    $tableName = $wpdb->prefix . "srs_simple_hits_counter";

    $sqlCmd = "CREATE TABLE IF NOT EXISTS " . $tableName . "(
	srs_id mediumint(9) UNSIGNED AUTO_INCREMENT NOT NULL,
	srs_date date,
	srs_time time,
	srs_post_id mediumint(9),
	srs_visitors_count mediumint(9),
	srs_views_count mediumint(9),
	PRIMARY KEY (srs_id)
	)DEFAULT CHARSET=utf8;";
    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sqlCmd);
}
register_activation_hook(__FILE__, 'srs_get_previous_visitors_views');
function srs_get_previous_visitors_views(){
    if(get_option('migrated_to_version') != 1){
        $srs_pageViews_count = get_option('srs_pageViews_count');
        $srs_visitors_count = get_option('srs_visitors_count');
        srs_reset_views_visitors(0, $srs_visitors_count, $srs_pageViews_count);
        update_option('migrated_to_version', '1' );
        update_option('srs_update_ran' ,1);
    }
}

// MIGRATION
add_action('wp_head', 'srs_plugin_data_migration');
add_action('admin_head', 'srs_plugin_data_migration');
function srs_plugin_data_migration(){
    if(get_option('srs_simple_hits_counter_version')!='1.0.2'){
        srs_hits_counter_installNewTables();
        srs_get_previous_visitors_views();
        update_option('srs_simple_hits_counter_version', '1.0.2');
        update_option('srs_update_ran', intval(get_option('srs_update_ran'))+1 );
    }
}


// ENQUEUE SCRIPTS
add_action('wp_footer','srs_simple_hits_counter_js');
function srs_simple_hits_counter_js() { ?>
    <script type="text/javascript">
        var templateUrl = '<?php echo get_site_url(); ?>';
        var post_id = '<?php echo get_the_ID(); ?>';
    </script>
    <?php  wp_enqueue_script( 'srs_simple_hits_counter_js', plugins_url( '/js/srs_simple_hits_counter_js.js', __FILE__ ), array('jquery'), '', true);
}

// UPDATE COUNTER
add_action('wp_ajax_srs_update_counter','srs_simple_hits_counter');
add_action('wp_ajax_nopriv_srs_update_counter','srs_simple_hits_counter');
function srs_simple_hits_counter(){
    $post_id = sanitize_text_field($_GET['post_id']);
    $visitors = $views = 0;

    if(!isset($_COOKIE['srs_unique_visitor'])){
        setcookie("srs_unique_visitor", "1", 0 ,'/', parse_url(site_url(), PHP_URL_HOST));
        $visitors = 1;
    }

    $views = 1;
    srs_update_views_visitors($post_id, $visitors, $views);
}
function srs_update_views_visitors($post_id, $visitors, $views){
    global $wpdb;
    $table_name = $wpdb->prefix.'srs_simple_hits_counter';
    $date = Date("Y-m-d");
    $time = Date("h:i:s");
    $post_data = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE (srs_post_id = %d AND srs_date = %s )", $post_id, $date));
    if ($post_data){
        $visitors = $post_data[0]->srs_visitors_count+$visitors;
        $views = $post_data[0]->srs_views_count+$views;
    }else{
        $visitors = $visitors;
        $views = $views;
    }

    if($post_data){
        $wpdb->update($table_name, array('srs_visitors_count' => $visitors, 'srs_views_count' => $views), array('srs_post_id' => $post_id, 'srs_date' => "$date"));
    }else{
        $sql = "INSERT INTO $table_name (`srs_id`, `srs_date`, `srs_time`, `srs_post_id`, `srs_visitors_count`, `srs_views_count`) VALUES (NULL, '".$date."', '".$time."', $post_id, $visitors, $views)";
        $wpdb->insert(
            $table_name,
            array(
                'srs_id' => NULL,
                'srs_date' => $date,
                'srs_time' => $time,
                'srs_post_id' => $post_id,
                'srs_visitors_count' =>$visitors,
                'srs_views_count' => $views
            )
        );
    }
}
function srs_reset_views_visitors($post_id, $visitors, $views){
    global $wpdb;
    $table_name = $wpdb->prefix.'srs_simple_hits_counter';
    $date = Date("Y-m-d");
    $time = Date("h:i:s");
    $post_data = $wpdb->get_results("SELECT * FROM $table_name WHERE srs_post_id = $post_id");
    if($post_data){
        if($visitors == 'null'){
            $visitors = $post_data[0]->srs_visitors_count;
        }
        if($views == 'null'){
            $views = $post_data[0]->srs_views_count;
        }
        $wpdb->update($table_name, array('srs_visitors_count' => $visitors, 'srs_views_count' => $views), array('srs_post_id' => $post_id));
    }else{
        if($visitors == 'null'){
            $visitors = 0;
        }
        if($views == 'null'){
            $views = 0;
        }
        $wpdb->insert(
            $table_name,
            array(
                'srs_id' => NULL,
                'srs_date' => $date,
                'srs_time' => $time,
                'srs_post_id' => $post_id,
                'srs_visitors_count' =>$visitors,
                'srs_views_count' => $views
            )
        );
    }
}
function srs_count_total_visitors_views($return){
    global $wpdb;
    $table_name = $wpdb->prefix . 'srs_simple_hits_counter';
    if ($return == 'views') {
        return $wpdb->get_results("SELECT SUM(srs_views_count) as total FROM $table_name ")[0];
    } else {
        return $wpdb->get_results("SELECT SUM(srs_visitors_count) as total FROM $table_name ")[0];
    }
}

// SHORTCODE
add_shortcode('srs_total_pageViews', 'srs_getTotal_pageViews');
function srs_getTotal_pageViews(){
    $data_return_views = srs_count_total_visitors_views('views');
    if(get_option('srs_pageViews_number_format_count') == 'yes'){
        return "<span class='page-views'>".number_format(intval($data_return_views->total))."</span>";
    }else{
        return "<span class='page-views'>".intval($data_return_views->total)."</span>";
    }
}
add_shortcode('srs_total_visitors', 'srs_getTotal_visitors');
function srs_getTotal_visitors(){
    $data_return_visitors = srs_count_total_visitors_views('visitors');
    if(get_option('srs_pageViews_number_format_count') == 'yes'){
        return "<span class='visitors'>".number_format(intval($data_return_visitors->total))."</span>";
    }else{
        return "<span class='visitors'>".intval($data_return_visitors->total)."</span>";
    }
}


// WIDGET
add_action( 'widgets_init', 'srs_shc_register_widget' );
function srs_shc_register_widget() {
    register_widget( 'SRS_SHC_Widget' );
}
class SRS_SHC_Widget extends WP_Widget {

    function __construct() {
        parent::__construct(
            'srs_shc_widget', // Base ID
            __( 'SRS Simple Hits Counter', 'text_domain' ), // Name
            array( 'description' => __( 'Add this widget to the sidebar or any other widget area available on your theme where you would like to display the Total Hits Count for your whole site.', 'text_domain' ), ) // Args
        );
    }

    public function widget( $args, $instance ) {
        echo $args['before_widget'];
        if ( ! empty( $instance['title'] ) ) {
            echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ). $args['after_title'];
        }
        if( $instance['type']=='visitors' ){
            $data_return_visitors = srs_count_total_visitors_views('visitors');
            if(get_option('srs_pageViews_number_format_count') == 'yes'){
                $srs_total_visitors =  number_format(intval( $data_return_visitors->total ));
            }else{
                $srs_total_visitors =  intval( $data_return_visitors->total );
            }
            echo "<span class='visitors'>" . __( $srs_total_visitors, 'text_domain' ) . "</span>";
        }elseif( $instance['type']=='pageviews' ){
            $data_return_views = srs_count_total_visitors_views('views');
            if(get_option('srs_pageViews_number_format_count') == 'yes'){
                $srs_total_pageViews =  number_format(intval( $data_return_views->total ));
            }else{
                $srs_total_pageViews =  intval( $data_return_views->total );
            }
            echo "<span class='page-views'>" . __( $srs_total_pageViews, 'text_domain' ) . "</span>";
        }

        echo $args['after_widget'];
    }

    public function form( $instance ) {
        $title = ! empty( $instance['title'] ) ? $instance['title'] : __( 'New title', 'text_domain' );
        $visitors_count = ! empty( $instance['visitors_count'] ) ? $instance['visitors_count'] : __( '00000', 'text_domain' );
        $pageViews_count = ! empty( $instance['pageViews_count'] ) ? $instance['pageViews_count'] : __( '00000', 'text_domain' );
        $type = ! empty( $instance['type'] ) ? $instance['type'] : __( 'visitors', 'text_domain' );
        ?>
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'type' ); ?>"><?php _e( 'Counter Type:' ); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'type' ); ?>" name="<?php echo $this->get_field_name( 'type' ); ?>" type="radio" value="visitors" <?php echo esc_attr( $type )=='visitors'?'checked':'' ; ?>>Visitors
            <input class="widefat" id="<?php echo $this->get_field_id( 'type' ); ?>" name="<?php echo $this->get_field_name( 'type' ); ?>" type="radio" value="pageviews" <?php echo esc_attr( $type )=='pageviews'?'checked':'' ; ?>>Page Views
        </p>

        <p>
            Reset options have been moved to the options page under the settings menu.
        </p>
        <?php
    }

    public function update( $new_instance, $old_instance ) {
        $instance = array();

        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? sanitize_text_field( $new_instance['title'] ) : '';
        $instance['type'] = ( ! empty( $new_instance['type'] ) ) ? sanitize_text_field( $new_instance['type'] ) : '';
        $instance['visitors_count_reset_check'] = ( ! empty( $new_instance['visitors_count_reset_check'] ) ) ? sanitize_text_field( $new_instance['visitors_count_reset_check'] ) : '';
        $instance['pageViews_count_reset_check'] = ( ! empty( $new_instance['pageViews_count_reset_check'] ) ) ? sanitize_text_field( $new_instance['pageViews_count_reset_check'] ) : '';

        return $instance;
    }
}

// Register and load Admin menus
add_action('admin_menu', 'srs_add_menu_function_call' );
function srs_add_menu_function_call(){
    $settings_page  = add_menu_page( 'SRS Simple Hits Counter Dashboard', 'Simple Counter', 'administrator', 'srs-simple-hits-counter', 'srs_hits_counter_graphs' );
    $page           = add_submenu_page( 'srs-simple-hits-counter', 'Dashboard', 'Dashboard', 'administrator', 'srs-simple-hits-counter', 'srs_hits_counter_graphs' );
    $page           = add_submenu_page( 'srs-simple-hits-counter', 'SRS Hits Counter Settings', 'Settings', 'administrator',  'srs-simple-hits-counter-settings','srs_admin_settings_page');
}

//generate graph and load js libraries  for graph
function srs_hits_counter_graphs(){

    global $wpdb;

    //load libraries for graph
    wp_enqueue_script( 'srs_hits_counter_Chart_bundle_js', plugins_url( '/js/Chart.bundle.min.js', __FILE__ ), array('jquery'), '', true);
    wp_enqueue_script( 'srs_hits_counter_Chart_js', plugins_url( '/js/Chart.min.js', __FILE__ ), array('jquery'), '', true);
    wp_enqueue_style( 'srs_hits_counter_Chart_css', plugins_url( '/css/style.css', __FILE__ ));

    //check if user select last month or last week option   .. default to last week
    $dates_range = array();
    $begin = new DateTime();
    if(isset($_GET['range_filter']) && sanitize_text_field($_GET['range_filter']) == 'month'){
        $xAxes_lable = "Month";
        $begin->sub(new DateInterval('P29D'));
        $end = new DateTime();
        $end->add(new DateInterval('P1D'));
        $interval = DateInterval::createFromDateString('1 day');
        $period = new DatePeriod($begin, $interval, $end);
        foreach ( $period as $dt ){
            $dates_range[] = $dt->format( "Y-m-d" );
        }
    }else{
        $xAxes_lable = "Week";
        $begin->sub(new DateInterval('P6D'));
        $end = new DateTime();
        $end->add(new DateInterval('P1D'));
        $interval = DateInterval::createFromDateString('1 day');
        $period = new DatePeriod($begin, $interval, $end);
        foreach ( $period as $dt ){
            $dates_range[] = $dt->format( "Y-m-d" );
        }
    }

    $table_name = $wpdb->prefix . 'srs_simple_hits_counter';

    //Get data for the graph
    $post_data = $wpdb->get_results("SELECT srs_id, srs_date, srs_time, srs_post_id,  sum(srs_visitors_count) srs_visitors_count, SUM(srs_views_count) srs_views_count FROM $table_name WHERE srs_date >= '".$begin->format( "Y-m-d" )."' GROUP BY srs_date ORDER BY srs_date DESC ");
    $total_count = $wpdb->get_results("SELECT sum(srs_visitors_count) srs_visitors_count, SUM(srs_views_count) srs_views_count FROM $table_name WHERE srs_date >= '".$begin->format( "Y-m-d" )."' ORDER BY srs_date DESC ");
    $lifetime_count = $wpdb->get_results("SELECT sum(srs_visitors_count) srs_visitors_count, SUM(srs_views_count) srs_views_count FROM $table_name ORDER BY srs_date DESC ");

    $popular_pages = $wpdb->get_results("SELECT srs_id, srs_date, srs_time, srs_post_id,  sum(srs_visitors_count) srs_visitors_count, SUM(srs_views_count) srs_views_count FROM $table_name WHERE srs_date >= '".$begin->format( "Y-m-d" )."' GROUP BY srs_post_id ORDER BY srs_views_count DESC ");


    ?>

    <div class="srs-simple-hits-counter">
        <div class="srs-base">
            <div class="srs-container">
                <!--Header-->
                <div class="srs-header">
                    <div class="srs-header-title">
                        <h2>Simple Hits Counter</h2>
                    </div>
                    <div class="srs-total-stats">
                        <div class="srs-total-title">Lifetime</div>
                        <div class="srs-total-visitors">
                            <div>Visitors:</div>
                            <div><?php echo number_format(intval($lifetime_count[0]->srs_visitors_count)) ?></div>
                        </div>
                        <div class="srs-total-views">
                            <div>Views:</div>
                            <div><?php echo number_format(intval($lifetime_count[0]->srs_views_count)) ?></div>
                        </div>
                    </div>
                </div>

                <!--Filter-->
                <div class="srs-filter srs-row">
                    <form action="" method="get" class="">
                        <select name="range_filter" style="">
                            <option value="week">Week to date</option>
                            <option value="month" <?php if(isset($_GET['range_filter']) && sanitize_text_field($_GET['range_filter']) == 'month'){ echo "selected"; } ?>>Month to date</option>
                        </select>
                        <input type="hidden" name="page" value="<?php echo esc_attr($_GET['page']) ?>">
                        <input type="submit" value="Apply" style="" class="button button-primary">
                    </form>
                </div>

                <!--Stats Row-->
                <div class="srs-row">

                    <!--Stats-->
                    <div class="srs-stats">
                        <div class="srs-stats-visitors">
                            <div class="srs-stats-title">Visitors</div>
                            <div class="srs-stats-count"><?php echo $total_count[0]->srs_visitors_count ?></div>
                        </div>
                        <div class="srs-stats-views">
                            <div class="srs-stats-title">Views</div>
                            <div class="srs-stats-count"><?php echo $total_count[0]->srs_views_count ?></div>
                        </div>
                    </div>

                    <!--Graph-->
                    <div class="srs-graph">
                        <!-- Add canvas in which we will show graph   -->
                        <canvas id="srs_visitors_views_charts" width="100" height="35"></canvas>
                    </div>

                    <!--Top pages-->
                    <div class="srs-top-pages">

                        <div class="srs-top-pages-title">
                            <h3>Popular Content</h3>
                            <p>Views</p>
                        </div>

                        <div class="srs-top-pages-container">
                            <?php foreach ($popular_pages as $page){ ?>
                                <div class="top-pages-row">
                                    <div class="top-pages-cols page-id"><?php echo $page->srs_post_id; ?></div>
                                    <div class="top-pages-cols page-title"><?php echo "<a target='_blank' href='".get_permalink($page->srs_post_id)."'>".(get_the_title($page->srs_post_id))."</a>"; ?></div>
                                    <div class="top-pages-cols page-views-count"><?php echo $page->srs_views_count; ?></div>
                                </div>
                            <?php }?>
                        </div>

                    </div>

                    <!--Credits-->
                    <div class="srs-credit">
                        <div class="atif-rocks">
                            <p>Simple Hits Counter by <a href="https://atif.rocks/">Atif Rocks</a></p>
                        </div>
                    </div>

                </div>

            </div>
        </div>
    </div>

    <script>
        //javascript code for graph
        var visitors = [];
        var views = [];
        var date_labels = [];
        var counter = 0;
        <?php
            $srs_visitors_count = 0;
            $srs_views_count = 0;
            $srs_date = 0;
            //$dates_range = array_reverse($dates_range);
            foreach ($dates_range as $date){
                $srs_date = date("M j", strtotime($date));
                foreach($post_data as $post){
                    if(date("Y-m-d", strtotime($post->srs_date)) == $date){
                        $srs_visitors_count = $post->srs_visitors_count;
                        $srs_views_count = $post->srs_views_count;
                    }
                }
                ?>
                visitors[counter] = '<?php echo $srs_visitors_count; ?>';
                views[counter]  = '<?php echo $srs_views_count; ?>';
                date_labels[counter] = '<?php echo $srs_date; ?>';
                counter ++;
                <?php
                $srs_visitors_count = 0;
                $srs_views_count = 0;
            }
        ?>
        window.chartColors = {
            red: 'rgb(255, 99, 132)',
            orange: 'rgb(255, 159, 64)',
            yellow: 'rgb(255, 205, 86)',
            green: 'rgb(75, 192, 192)',
            blue: 'rgb(54, 162, 235)',
            purple: 'rgb(153, 102, 255)',
            grey: 'rgb(201, 203, 207)'
        };
        var config = {
            type: 'line',
            data: {
                labels: date_labels,
                datasets: [{
                    label: "Visitors",
                    backgroundColor: window.chartColors.green,
                    borderColor: window.chartColors.green,
                    fill: false,
                    data: visitors,
                }, {
                    label: "Views",
                    fill: false,
                    backgroundColor: window.chartColors.grey,
                    borderColor: window.chartColors.grey,
                    data: views,
                }]
            },
            options: {
                responsive: true,
                /*title:{
                    display:true,
                    text:'Graph'
                },*/
                tooltips: {
                    mode: 'index',
                    intersect: false,
                },
                hover: {
                    mode: 'nearest',
                    intersect: true
                },
                /*scales: {
                    xAxes: [{
                        display: true,
                        scaleLabel: {
                            display: true,
                            labelString: '',
                            fontSize: 24,
                            lineHeight: 1,
                            fontColor: '#333333'
                        }
                    }],
                    yAxes: [{
                        display: true,
                        scaleLabel: {
                            display: true,
                            labelString: 'Value'
                        }
                    }]
                }*/
            }
        };
        window.onload = function() {
            var ctx = document.getElementById("srs_visitors_views_charts").getContext("2d");
            window.myLine = new Chart(ctx, config);
        };
    </script>
    <?php
}

function srs_admin_settings_page(){
    global $wpdb;

    wp_enqueue_style( 'srs_hits_counter_Chart_css', plugins_url( '/css/style.css', __FILE__ ));


    $table_name = $wpdb->prefix.'srs_simple_hits_counter';
//    echo '<h1>SRS Simple Hits Counter</h1>';

    if( isset($_POST['srs_shc_options_save']) && wp_verify_nonce($_POST['srs-form-nonce'], 'srs-form-9171') ){

        // Reset Unique Visitor Counter
        if (isset($_POST['unique_visitor_checkbox'])){
            if( $_POST['unique_visitor_reset_val']!='' && $_POST['unique_visitor_checkbox'] == "yes" ){
                $sql = "UPDATE $table_name SET `srs_visitors_count` = '0'";
                $wpdb->query($sql);
                $views = 'null';

                srs_reset_views_visitors(0, sanitize_text_field($_POST['unique_visitor_reset_val']), $views);
            }
        }

        // Reset Page Views Counter
        if (isset($_POST['page_views_checkbox'])){
            if( $_POST['page_views_reset_val']!='' &&$_POST['page_views_checkbox'] == "yes" ){
                $sql = "UPDATE $table_name SET `srs_views_count` = '0' ";
                $wpdb->query($sql);
                $visitors = 'null';

                srs_reset_views_visitors(0, $visitors, sanitize_text_field($_POST['page_views_reset_val']));
            }
        }

        // Change number format
        if(isset($_POST['page_views_number_format_checkbox']) && $_POST['page_views_number_format_checkbox'] == 'yes'){
            update_option('srs_pageViews_number_format_count', 'yes' );
        }else{
            update_option('srs_pageViews_number_format_count', 'no' );
        }

        // Reset plugin data
        if (isset($_POST['reset_data']) && $_POST['reset_data'] == 'yes'){
                $wpdb->query("TRUNCATE $table_name");
        }
    }
    $data_return_visitors = srs_count_total_visitors_views('visitors');
    $data_return_views = srs_count_total_visitors_views('views');
    $srs_shc_unique_visitors_count = $data_return_visitors->total;
    $srs_shc_page_views_count = $data_return_views->total;
    $page_views_number_format_checkbox = get_option('srs_pageViews_number_format_count');
    ?>

    <div class="srs-simple-hits-counter">
        <div class="srs-base">
            <form method="post" action="">
                <div class="srs-container">

                    <!--Header-->
                    <div class="srs-header">
                        <div class="srs-header-title">
                            <h2>Simple Hits Counter</h2>
                        </div>
                    </div>

                    <!--Shortcodes-->
                    <div class="srs-row">
                        <div class="srs-shortcodes">
                            <div class="srs-shortcodes-title">
                                <h3>Shortcodes</h3>
                            </div>
                            <div class="srs-shortcodes-container">
                                <div class="srs-shortcodes-row">
                                    <div class="srs-shortcode-type">Unique Visitors</div>
                                    <div class="srs-shortcode"> [srs_total_visitors]</div>
                                </div>
                                <div class="srs-shortcodes-row">
                                    <div class="srs-shortcode-type">Page Views</div>
                                    <div class="srs-shortcode">[srs_total_pageViews]</div>
                                </div>

                            </div>
                        </div>
                    </div>

                    <!--Reset Counters-->
                    <div class="srs-row">
                        <div class="srs-reset-counters">
                            <div class="srs-reset-counters-title">
                                <h3>Reset Counters</h3>
                            </div>
                            <div class="srs-reset-counters-container">
                                <div class="srs-reset-counters-row">
                                    <div class="srs-reset-counters-type">Unique Visitors</div>
                                    <div class="srs-shortcode">
                                        <input type="text" name="unique_visitor_reset_val" placeholder="00000" value="<?php echo $srs_shc_unique_visitors_count ?>">
                                        <br><span class="description">Are you sure you want to reset 'Unique Visitors Counter'? <input type="checkbox" name="unique_visitor_checkbox" value="yes"></span>
                                    </div>
                                </div>
                                <div class="srs-reset-counters-row">
                                    <div class="srs-reset-counters-type">Page Views</div>
                                    <div class="srs-shortcode">
                                        <input type="text" name="page_views_reset_val" placeholder="00000" value="<?php echo $srs_shc_page_views_count ?>">
                                        <br><span class="description">Are you sure you want to reset 'Page Views Counter'? <input type="checkbox" name="page_views_checkbox" value="yes"></span>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>

                    <!--Formatting-->
                    <div class="srs-row">
                        <div class="srs-reset-counters">
                            <div class="srs-formatting-title">
                                <h3>Formatting</h3>
                            </div>
                            <div class="srs-formatting-container">
                                <div class="srs-formatting-row">
                                    <div class="srs-formatting-type">Add Commas?</div>
                                    <div class="srs-shortcode">
                                        <span class="description">Yes? <input type="checkbox" name="page_views_number_format_checkbox" value="yes" <?php if(isset($page_views_number_format_checkbox) && $page_views_number_format_checkbox == 'yes' ){ echo "checked"; } ?> > Example:(10,000,000) </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!--Reset plugin-->
                    <div class="srs-row">
                        <div class="srs-reset-plugin">
                            <div class="srs-reset-plugin-title">
                                <h3>Reset Plugin</h3>
                            </div>
                            <div class="srs-reset-plugin-container">
                                <div class="srs-reset-plugin-row">
                                    <div class="srs-reset-plugin-type">Reset</div>
                                    <div class="srs-shortcode">
                                        <span class="description">Yes? <input type="checkbox" name="reset_data" value="yes" > Deletes all the existing plugin data and starts fresh </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!--Submit-->
                    <?php $nonce = wp_create_nonce('srs-form-9171') ?>
                    <input type="hidden" name="srs-form-nonce" value="<?php echo $nonce ?>" />
                    <p class="submit">
                        <input type="submit" name="srs_shc_options_save" class="button-primary" value="Save settings">
                    </p>

                </div>
            </form>
        </div>
    </div>

    <?php
}