<?php
/*
Plugin Name: Zcube Theme Plugin
Plugin URI: http://zcube.in
Description: This plugin creates a custom post types Portfolio and Shortcode is [advanced-portfolio]
Version: 1.0.1
Author: zcube
Author URI: http://zcube.in

*/
/**
 * Register Team Custom Post Type
 */
 
 

 function isik__portfolio() {
  $labels = array(
    'name'               => _x( 'Portfolios', 'post type general name' ),
    'singular_name'      => _x( 'Portfolio', 'post type singular name' ),
    'add_new'            => _x( 'Add New', 'book' ),
    'add_new_item'       => __( 'Add New portfolio' ),
    'edit_item'          => __( 'Edit portfolio' ),
    'new_item'           => __( 'New portfolio' ),
    'all_items'          => __( 'All portfolios' ),
    'view_item'          => __( 'View portfolio' ),
    'search_items'       => __( 'Search portfolios' ),
    'not_found'          => __( 'No portfolios found' ),
    'not_found_in_trash' => __( 'No portfolios found in the Trash' ),
    'menu_name'          => 'Portfolios'
  );
  $args = array(
    'labels'        => $labels,
    'description'   => 'Holds our portfolios and portfolio specific data',
    'public'        => true,
    'menu_position' => 5,
    'supports'      => array( 'title', 'editor', 'thumbnail', 'excerpt', 'comments' ),
    'has_archive'   => true,
  );
  register_post_type( 'portfolio', $args );
}
add_action( 'init', 'isik__portfolio' );
 function my_taxonomies_portfolio() {
   $labels = array(
     'name'              => _x( 'portfolio Categories', 'taxonomy general name' ),
     'singular_name'     => _x( 'portfolio Category', 'taxonomy singular name' ),
     'search_items'      => __( 'Search portfolio Categories' ),
     'all_items'         => __( 'All portfolio Categories' ),
     'parent_item'       => __( 'Parent portfolio Category' ),
     'parent_item_colon' => __( 'Parent portfolio Category:' ),
     'edit_item'         => __( 'Edit portfolio Category' ),
     'update_item'       => __( 'Update portfolio Category' ),
     'add_new_item'      => __( 'Add New portfolio Category' ),
     'new_item_name'     => __( 'New portfolio Category' ),
     'menu_name'         => __( 'portfolio Categories' ),
   );
   $args = array(
     'labels' => $labels,
     'hierarchical' => true,
   );
   register_taxonomy( 'portfolio_category', 'portfolio', $args );
 }
 add_action( 'init', 'my_taxonomies_portfolio', 0 );
 
 
 
 
// Register Custom Post Type Team
function create_Team_cpt() {

	$labels = array(
		'name' => _x( 'Teams', 'Post Type General Name', 'luxia' ),
		'singular_name' => _x( 'Team', 'Post Type Singular Name', 'luxia' ),
		'menu_name' => _x( 'Teams', 'Admin Menu text', 'luxia' ),
		'name_admin_bar' => _x( 'Team', 'Add New on Toolbar', 'luxia' ),
		'archives' => __( 'Team Archives', 'luxia' ),
		'attributes' => __( 'Team Attributes', 'luxia' ),
		'parent_item_colon' => __( 'Parent Team:', 'luxia' ),
		'all_items' => __( 'All Teams', 'luxia' ),
		'add_new_item' => __( 'Add New Team', 'luxia' ),
		'add_new' => __( 'Add New', 'luxia' ),
		'new_item' => __( 'New Team', 'luxia' ),
		'edit_item' => __( 'Edit Team', 'luxia' ),
		'update_item' => __( 'Update Team', 'luxia' ),
		'view_item' => __( 'View Team', 'luxia' ),
		'view_items' => __( 'View Teams', 'luxia' ),
		'search_items' => __( 'Search Team', 'luxia' ),
		'not_found' => __( 'Not found', 'luxia' ),
		'not_found_in_trash' => __( 'Not found in Trash', 'luxia' ),
		'featured_image' => __( 'Featured Image', 'luxia' ),
		'set_featured_image' => __( 'Set featured image', 'luxia' ),
		'remove_featured_image' => __( 'Remove featured image', 'luxia' ),
		'use_featured_image' => __( 'Use as featured image', 'luxia' ),
		'insert_into_item' => __( 'Insert into Team', 'luxia' ),
		'uploaded_to_this_item' => __( 'Uploaded to this Team', 'luxia' ),
		'items_list' => __( 'Teams list', 'luxia' ),
		'items_list_navigation' => __( 'Teams list navigation', 'luxia' ),
		'filter_items_list' => __( 'Filter Teams list', 'luxia' ),
	);
	$args = array(
		'label' => __( 'Team', 'luxia' ),
		'description' => __( 'post Teams', 'luxia' ),
		'labels' => $labels,
		'menu_icon' => 'dashicons-admin-generic',
		'supports' => array('title', 'editor', 'excerpt', 'thumbnail', 'page-attributes', 'custom-fields'),
		'taxonomies' => array('category'),
		'public' => true,
		'show_ui' => true,
		'show_in_menu' => true,
		'menu_position' => 5,
		'show_in_admin_bar' => true,
		'show_in_nav_menus' => true,
		'can_export' => true,
		'has_archive' => true,
		'hierarchical' => false,
		'exclude_from_search' => false,
		'show_in_rest' => true,
		'publicly_queryable' => true,
		'capability_type' => 'post',
	);
	register_post_type( 'Team', $args );

}
add_action( 'init', 'create_Team_cpt', 0 );



// Register Custom Post Type Courses
function create_courses_cpt() {

	$labels = array(
		'name' => _x( 'courses', 'Post Type General Name', 'luxia' ),
		'singular_name' => _x( 'Courses', 'Post Type Singular Name', 'luxia' ),
		'menu_name' => _x( 'courses', 'Admin Menu text', 'luxia' ),
		'name_admin_bar' => _x( 'Courses', 'Add New on Toolbar', 'luxia' ),
		'archives' => __( 'Courses Archives', 'luxia' ),
		'attributes' => __( 'Courses Attributes', 'luxia' ),
		'parent_item_colon' => __( 'Parent Service:', 'luxia' ),
		'all_items' => __( 'All courses', 'luxia' ),
		'add_new_item' => __( 'Add New Courses', 'luxia' ),
		'add_new' => __( 'Add New', 'luxia' ),
		'new_item' => __( 'New Courses', 'luxia' ),
		'edit_item' => __( 'Edit Courses', 'luxia' ),
		'update_item' => __( 'Update Courses', 'luxia' ),
		'view_item' => __( 'View Courses', 'luxia' ),
		'view_items' => __( 'View courses', 'luxia' ),
		'search_items' => __( 'Search Courses', 'luxia' ),
		'not_found' => __( 'Not found', 'luxia' ),
		'not_found_in_trash' => __( 'Not found in Trash', 'luxia' ),
		'featured_image' => __( 'Featured Image', 'luxia' ),
		'set_featured_image' => __( 'Set featured image', 'luxia' ),
		'remove_featured_image' => __( 'Remove featured image', 'luxia' ),
		'use_featured_image' => __( 'Use as featured image', 'luxia' ),
		'insert_into_item' => __( 'Insert into Courses', 'luxia' ),
		'uploaded_to_this_item' => __( 'Uploaded to this Courses', 'luxia' ),
		'items_list' => __( 'courses list', 'luxia' ),
		'items_list_navigation' => __( 'courses list navigation', 'luxia' ),
		'filter_items_list' => __( 'Filter courses list', 'luxia' ),
		
		
	);
	$args = array(
		'label' => __( 'Courses', 'luxia' ),
		'description' => __( 'post courses', 'luxia' ),
		'labels' => $labels,
		'menu_icon' => 'dashicons-admin-generic',
		'supports' => array('title', 'editor', 'excerpt', 'thumbnail', 'page-attributes', 'custom-fields'),
		'taxonomies' => array('category', 'tag'),
		'public' => true,
		'show_ui' => true,
		'show_in_menu' => true,
		'menu_position' => 5,
		'show_in_admin_bar' => true,
		'show_in_nav_menus' => true,
		'can_export' => true,
		'has_archive' => true,
		'hierarchical' => false,
		'exclude_from_search' => false,
		'show_in_rest' => true,
		'publicly_queryable' => true,
		'capability_type' => 'post',
	);
	register_post_type( 'courses', $args );

}
add_action( 'init', 'create_courses_cpt', 0 );

// Register Custom Post Type kids courses
function create_kids_courses_cpt() {

	$labels = array(
		'name' => _x( 'kids courses', 'Post Type General Name', 'luxia' ),
		'singular_name' => _x( 'kids courses', 'Post Type Singular Name', 'luxia' ),
		'menu_name' => _x( 'kids courses', 'Admin Menu text', 'luxia' ),
		'name_admin_bar' => _x( 'kids courses', 'Add New on Toolbar', 'luxia' ),
		'archives' => __( 'kids courses Archives', 'luxia' ),
		'attributes' => __( 'kids courses Attributes', 'luxia' ),
		'parent_item_colon' => __( 'Parent kids courses:', 'luxia' ),
		'all_items' => __( 'All kids courses', 'luxia' ),
		'add_new_item' => __( 'Add New kids courses', 'luxia' ),
		'add_new' => __( 'Add New', 'luxia' ),
		'new_item' => __( 'New kids courses', 'luxia' ),
		'edit_item' => __( 'Edit kids courses', 'luxia' ),
		'update_item' => __( 'Update kids courses', 'luxia' ),
		'view_item' => __( 'View kids courses', 'luxia' ),
		'view_items' => __( 'View kids courses', 'luxia' ),
		'search_items' => __( 'Search kids courses', 'luxia' ),
		'not_found' => __( 'Not found', 'luxia' ),
		'not_found_in_trash' => __( 'Not found in Trash', 'luxia' ),
		'featured_image' => __( 'Featured Image', 'luxia' ),
		'set_featured_image' => __( 'Set featured image', 'luxia' ),
		'remove_featured_image' => __( 'Remove featured image', 'luxia' ),
		'use_featured_image' => __( 'Use as featured image', 'luxia' ),
		'insert_into_item' => __( 'Insert into kids courses', 'luxia' ),
		'uploaded_to_this_item' => __( 'Uploaded to this kids courses', 'luxia' ),
		'items_list' => __( 'kids courses list', 'luxia' ),
		'items_list_navigation' => __( 'kids courses list navigation', 'luxia' ),
		'filter_items_list' => __( 'Filter kids courses list', 'luxia' ),
		
		
	);
	$args = array(
		'label' => __( 'kids courses', 'luxia' ),
		'description' => __( 'post kids courses', 'luxia' ),
		'labels' => $labels,
		'menu_icon' => 'dashicons-admin-generic',
		'supports' => array('title', 'editor', 'excerpt', 'thumbnail', 'page-attributes', 'custom-fields'),
		'taxonomies' => array('category'),
		'public' => true,
		'show_ui' => true,
		'show_in_menu' => true,
		'menu_position' => 5,
		'show_in_admin_bar' => true,
		'show_in_nav_menus' => true,
		'can_export' => true,
		'has_archive' => true,
		'hierarchical' => false,
		'exclude_from_search' => false,
		'show_in_rest' => true,
		'publicly_queryable' => true,
		'capability_type' => 'post',
	);
	register_post_type( 'kids courses', $args );

}
add_action( 'init', 'create_kids_courses_cpt', 0 );
// Register Custom Post Type Events
function create_events_cpt() {

	$labels = array(
		'name' => _x( 'events', 'Post Type General Name', 'luxia' ),
		'singular_name' => _x( 'Events', 'Post Type Singular Name', 'luxia' ),
		'menu_name' => _x( 'events', 'Admin Menu text', 'luxia' ),
		'name_admin_bar' => _x( 'Events', 'Add New on Toolbar', 'luxia' ),
		'archives' => __( 'Events Archives', 'luxia' ),
		'attributes' => __( 'Events Attributes', 'luxia' ),
		'parent_item_colon' => __( 'Parent Events:', 'luxia' ),
		'all_items' => __( 'All events', 'luxia' ),
		'add_new_item' => __( 'Add New Events', 'luxia' ),
		'add_new' => __( 'Add New', 'luxia' ),
		'new_item' => __( 'New Events', 'luxia' ),
		'edit_item' => __( 'Edit Events', 'luxia' ),
		'update_item' => __( 'Update Events', 'luxia' ),
		'view_item' => __( 'View Events', 'luxia' ),
		'view_items' => __( 'View events', 'luxia' ),
		'search_items' => __( 'Search Events', 'luxia' ),
		'not_found' => __( 'Not found', 'luxia' ),
		'not_found_in_trash' => __( 'Not found in Trash', 'luxia' ),
		'featured_image' => __( 'Featured Image', 'luxia' ),
		'set_featured_image' => __( 'Set featured image', 'luxia' ),
		'remove_featured_image' => __( 'Remove featured image', 'luxia' ),
		'use_featured_image' => __( 'Use as featured image', 'luxia' ),
		'insert_into_item' => __( 'Insert into Events', 'luxia' ),
		'uploaded_to_this_item' => __( 'Uploaded to this Events', 'luxia' ),
		'items_list' => __( 'events list', 'luxia' ),
		'items_list_navigation' => __( 'events list navigation', 'luxia' ),
		'filter_items_list' => __( 'Filter events list', 'luxia' ),
		
		
	);
	$args = array(
		'label' => __( 'Events', 'luxia' ),
		'description' => __( 'post events', 'luxia' ),
		'labels' => $labels,
		'menu_icon' => 'dashicons-admin-generic',
		'supports' => array('title', 'editor', 'excerpt', 'thumbnail', 'page-attributes', 'custom-fields'),
		'taxonomies' => array('category'),
		'public' => true,
		'show_ui' => true,
		'show_in_menu' => true,
		'menu_position' => 5,
		'show_in_admin_bar' => true,
		'show_in_nav_menus' => true,
		'can_export' => true,
		'has_archive' => true,
		'hierarchical' => false,
		'exclude_from_search' => false,
		'show_in_rest' => true,
		'publicly_queryable' => true,
		'capability_type' => 'post',
	);
	register_post_type( 'events', $args );

}
add_action( 'init', 'create_events_cpt', 0 );