<?php
    /**
     * For full documentation, please visit: http://docs.reduxframework.com/
     * For a more extensive sample-config file, you may look at:
     * https://github.com/reduxframework/qeducato/blob/master/sample/sample-config.php
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = "qeducato_data";


    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
      'opt_name' => 'qeducato_data',
      'dev_mode' => false,
      'use_cdn' => true,
      'display_name' => $theme->get( 'Name' ),
      'display_version' => $theme->get( 'Version' ),
      'page_slug' => '_options',
      'page_title' => esc_html__('Theme Options', 'qeducato'),
      'admin_bar' => true,
      'menu_type' => 'menu',
      'menu_title' => esc_html__('Theme Options', 'qeducato'),
      'admin_bar_icon' => 'dashicons-admin-generic',
      'allow_sub_menu' => true,
      'page_parent_post_type' => 'your_post_type',
      'customizer' => true,
      'hints' => array(
        'icon'          => 'el el-question-sign',
        'icon_position' => 'right',
        'icon_size'     => 'normal',
        'tip_style'     => array(
          'color' => 'dark',
        ),
        'tip_position' => array(
          'my' => 'top left',
          'at' => 'bottom right',
        ),
        'tip_effect' => array(
          'show' => array(
            'duration' => '500',
            'event'    => 'mouseover',
          ),
          'hide' => array(
            'duration' => '500',
            'event'    => 'mouseleave unfocus',
          ),
        ),
      ),
      'output' => true,
      'output_tag' => true,
      'settings_api' => true,
      'cdn_check_time' => '1440',
      'compiler' => true,
      'page_permissions' => 'manage_options',
      'save_defaults' => true,
      'show_import_export' => true,
      'transient_time' => '3400',
      'network_sites' => true,
      'disable_tracking' => true,
    );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    // General Settings
    Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'General Settings', 'qeducato' ),
      'id'     => 'qeducato__section-general',
      'icon'   => 'el el-cogs',
      'fields' => array(
        array(
          'id'        => 'qeducato__opt-logo-standard',
          'type'      => 'media',
          'url'       => true,
          'title'     => esc_html__('Logo Image 1', 'qeducato'),
          'compiler'  => 'true',
          'desc'      => esc_html__('Upload your image or remove image', 'qeducato'),
          'default'   => array(
            'url'     => get_template_directory_uri() . '/inc/assets/images/logo.png'),
        ),
        array(
          'id'        => 'qeducato__opt-logo-standard-w',
          'type'      => 'media',
          'url'       => true,
          'title'     => esc_html__('Logo Image 2', 'qeducato'),
          'compiler'  => 'true',
          'desc'      => esc_html__('Upload your image or remove image', 'qeducato'),
          'default'   => array(
            'url'     => get_template_directory_uri() . '/inc/assets/images/f_logo.png'),
        ),
      )
    ) );
    

// Header email and phone number Top Bar
    Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'Header Top Bar', 'qeducato' ),
      'id'     => 'qeducato__subsection-header-top-bar ',
      'fields' => array(
		array(
          'id'        => 'qeducato__opt-Header-layout',
          'title'     => esc_html__('Change Header Layout', 'qeducato'),
		   'type'     => 'image_select',
          'options'   => array(
				11 => array(

					'img' => get_template_directory_uri() . '/inc/admin/images/hader01.png',
                    'alt' => esc_html__( 'Header Layout 1', 'qeducato' ),
				),	
                22 => array(

					'img' => get_template_directory_uri() . '/inc/admin/images/hader02.png',
                    'alt' => esc_html__( 'Header Layout 1', 'qeducato' ),
				),	
                33 => array(

					'img' => get_template_directory_uri() . '/inc/admin/images/hader03.png',
                    'alt' => esc_html__( 'Header Layout 1', 'qeducato' ),
				),	
             
		  ),

		  'default' => 11

        ),
           array(
          'id'        => 'qeducato_opt-header-top-bar',
          'type'      => 'switch',
          'title'     => esc_html__('Show Header Top Bar?', 'qeducato'),
          'subtitle'  => esc_html__('Turn on to show Top Bar in the top of the Header.', 'qeducato'),
          'default'   => 2,
          'on'        => esc_html__('Yes', 'qeducato'),
          'off'       => esc_html__('No', 'qeducato'),
        ),
       
        array(
          'id'        => 'qeducato_opt-header-top-bar-email',
          'type'      => 'switch',
          'title'     => esc_html__('Display Email Address?', 'qeducato'),
          'subtitle'  => esc_html__('Turn on to display the email address in the Header Top Bar.', 'qeducato'),
          'default'   => 2,
          'on'        => esc_html__('Yes', 'qeducato'),
          'off'       => esc_html__('No', 'qeducato'),
        ),

         array(
          'id'        => 'qeducato_opt-header-top-email-img',
          'type'      => 'media',
          'title'     => esc_html__('Email Icon img', 'qeducato'),
          'subtitle'  => esc_html__('Email Icon img to display next to the envelope icon.', 'qeducato'),
          'default'   => array(
            'url'     => get_template_directory_uri() . '/inc/assets/images/mailing.png'),
          'required'  => array('qeducato_opt-header-top-bar-email', '=', '1'),
        ),

        array(
          'id'        => 'qeducato_opt-header-top-email',
          'type'      => 'text',
          'title'     => esc_html__('Email address', 'qeducato'),
          'subtitle'  => esc_html__('Email address to display next to the envelope icon.', 'qeducato'),
          'default'   => esc_html__('info@example.com', 'qeducato'),
          'required'  => array('qeducato_opt-header-top-bar-email', '=', '1'),
        ),


        array(
          'id'        => 'qeducato_opt-header-top-bar-phone',
          'type'      => 'switch',
          'title'     => esc_html__('Display Phone Number?', 'qeducato'),
          'subtitle'  => esc_html__('Turn on to display the number in the Header Top Bar.', 'qeducato'),
          'default'   => 2,
          'on'        => esc_html__('Yes', 'qeducato'),
          'off'       => esc_html__('No', 'qeducato'),
        ),
         array(
          'id'        => 'qeducato_opt-header-top-phone-img',
          'type'      => 'media',
          'title'     => esc_html__('Phone Icon img', 'qeducato'),
          'subtitle'  => esc_html__('Phone Icon img to display next to the envelope icon.', 'qeducato'),
          'default'   => array(
            'url'     => get_template_directory_uri() . '/inc/assets/images/phone-call.png'),
          'required'  => array('qeducato_opt-header-top-bar-phone', '=', '1'),
        ),

        array(
          'id'        => 'qeducato_opt-header-top-phone',
          'type'      => 'text',
          'title'     => esc_html__('Get Phone Number', 'qeducato'),
          'subtitle'  => esc_html__('Phone Number to display next to the envelope icon.', 'qeducato'),
          'default'   => esc_html__('+91 705 2101 786', 'qeducato'),
          'required'  => array('qeducato_opt-header-top-bar-phone', '=', '1'),
        ),    
          
           array(
          'id'        => 'qeducato_opt-header-top-bar-contact',
          'type'      => 'switch',
          'title'     => esc_html__('Display Social Button?', 'qeducato'),
          'subtitle'  => esc_html__('Turn on to display the social button in the Header Top Bar.', 'qeducato'),
          'default'   => 2,
          'on'        => esc_html__('Yes', 'qeducato'),
          'off'       => esc_html__('No', 'qeducato'),
        ),
        array(
          'id'        => 'qeducato_opt-header-top-contact',
          'type'      => 'textarea',
          'title'     => esc_html__('Get Social Button', 'qeducato'),
          'subtitle'  => esc_html__('Get an social button', 'qeducato'),
          'default'   => esc_html__('Contact Button', 'qeducato'),
          'required'  => array('qeducato_opt-header-top-bar-contact', '=', '1'),
        ),       
     
    
      )
    ) );


	// Header Right Menu

    Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'Header Right Menu', 'qeducato' ),
      'id'     => 'qeducato__subsection-right-menu',
      'subsection' => true,
      'fields' => array(
          array(
            'id'        => 'qeducato__opt-right-menu',
            'type'      => 'switch',
            'title'     => esc_html__('Switch', 'qeducato'),
			 'default'   => 2,
            'on'        => esc_html__( 'Yes', 'qeducato' ),
            'off'       => esc_html__( 'No', 'qeducato' ),
          ),

          array(
            'id'      => 'qeducato__right-menu',
            'type'    => 'textarea',
            'title'   => esc_html__( 'Right Menu Text', 'qeducato' ),
			'default'   => 1,
            'default' => ' <a href="contact.html" class="btn ss-btn">Get A Quote</a>',
            'required'  => array('qeducato__opt-right-menu', '=', '1'),
          ),
      )
        
        
    ) );


	 ///////////////////////////////////////////////////////// Theme color///////////////////////////////////////
    Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'Theme Colors', 'qeducato' ),
      'id'     => 'qeducato__section-color',
      'icon'   => 'el el-arrow-down',
      'fields' => array(
      )
    ) );

	Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'General Theme Colors', 'qeducato' ),
      'id'     => 'qeducato__subsection-general-theme-color',
	  'subsection' => true,
      'fields' => array(
	   array(
          'id'        => 'qeducato__opt-body-text-color',
          'type'      => 'color',
          'title'     => esc_html__('Body Text Color', 'qeducato'),
		   'default' => '#6e6e6e',
		  'output'  => array('body,.widget_categories a'),
		  'subtitle' => esc_html__('Theme Text Body Color Manage from the Redux Controller', 'qeducato'),
        ),
		 array(
			'id'       => 'opt-color-blog',
			'type'     => 'background',
			'output'   => array('.site-content'),
			'title'    => esc_html__('Page Background Color', 'qeducato'),
			'subtitle' => esc_html__('Pick a Page Background color for the theme', 'qeducato'),
            'default'  => array(
            'background-color'    => '#ffffff',
          ),
		),
		 array(
			'id'       => 'opt-color-breadcums',
			'type'     => 'background',
			'output'  => array('.breadcrumb-area'),
			'title'    => esc_html__('Breadcums Background Color', 'qeducato'),
			'subtitle' => esc_html__('Pick a Breadcums background color for the theme', 'qeducato'),
			'default'               => array(
            'background-color'    => '#20282E',
			
          ),
		),
		array(
			'id'       => 'opt-color-footer',
			'type'     => 'background',
			'output'  => array('.footer-bg'),
			'title'    => esc_html__('Footer Background Color', 'qeducato'),
			'subtitle' => esc_html__('Pick a Footer background color for the theme', 'qeducato'),
			'default'               => array(
            'background-color'    => '#00173c',
          ),
		),
          
       array(
			'id'        => 'opt-color-bakground',
			'type'      => 'color',
			'title'     => esc_html__('Primary Color', 'qeducato'),
			'subtitle'  => esc_html__('Pick a background color.', 'qeducato'),
			'default'   => '#ff5e15',
			'output'    => array(
				'background-color' => '.footer-social a:hover,.contact-form .btn,.about-area .btn:hover::before,.bsingle__content .blog__btn .btn,.s-about-content .footer-social a:hover,.project-detail .project-info li .btn,.testimonial-active2 .slick-dots .slick-active button,.slider-content h2 span::after,.home-blog-active .slick-arrow, .home-blog-active2 .slick-arrow,.button-group button.active,.breadcrumb,.f-widget-title h2::before, .footer-widget .widgettitle::before,.copyright-wrap,.f-contact i,.cta-area .btn,.event-content .date,.blog-thumb2 .date-home,.step-box .date-box,.about-content2 li .ano,.class-active .slick-arrow,.courses-content .cat,.about-text,.services-box07:hover, .services-box07.active,.second-header::before,.second-header-btn .btn,.slider-content h5::after,.slider-active .slider-btn .btn,.post__tag ul li a:hover,.services-categories li a::after,.brochures-box .inner,.home-blog-active .slick-arrow:hover, .home-blog-active2 .slick-arrow:hover,.portfolio .col3 .grid-item .box a::after,.comment-form .submit,#scrollUp,.search-form .search-submit, .wp-block-search .wp-block-search__button,.top-btn,.widget-social a:hover,.comment-form .submit:hover,.services-08-item:hover .readmore,#scrollUp:hover,.gallery-image figcaption .span::before,.team-thumb .dropdown .xbtn,.blog-content2 .date-home,.f-cta-icon i,.contact-bg02 .btn.ss-btn.active',
				'color'            => '.event03 .event-content .time i,.faq-wrap .card-header h2 button::after,.bsingle__content h2:hover a,.testimonial-active2 .ta-info span,.services-box a:hover,.main-menu ul li:hover > a,.main-menu ul li a::after,.project-detail .project-info li .icon,.main-menu ul li:hover > a,.cta-title h2 span,.recent-blog-footer span,.b-meta i,.section-title h5,.event-content .time strong,.courses-content a.readmore,.about-title h5,.header-cta ul li i,blockquote footer,.pricing-body li::before,.pricing-box2.active .price-count h2, .pricing-box2.active .pricing-head h2,.header-three .main-menu .sub-menu li a:hover, .menu .children li a:hover,.footer-link ul li a:hover,.comment-text .avatar-name span,.team-area-content span,.team-area-content li .icon i,.header-social a,a:hover,.services-08-thumb.glyph-icon i,.gallery-image figcaption .span,.team-info span,.team-info h4 a:hover,.single-team:hover .team-info h4,.testimonial-active .slick-arrow,.blog-btn a,.bsingle__post .video-p .video-i,.bsingle__content .meta-info ul li i,.about-content li .icon i',
				'border-color'     => '.slider-active .slider-btn .btn,.contact-form .btn,.faq-btn,.about-area .btn:hover,.menu .sub-menu, .menu .children,.second-header-btn .btn,.cta-area .btn,.slider-active .slider-btn .btn,.post__tag ul li a:hover,.pricing-box2.active,.menu .children,.sidebar-widget .widgettitle,.tag-cloud-link:hover,.widget-social a:hover,.services-08-item:hover .readmore,.team-info .text,.blog-btn a,.contact-bg02 .btn.ss-btn.active'

			)
		),
          
        array(
			'id'        => 'opt-color-whtext',
			'type'      => 'color',
			'title'     => esc_html__('Primary White Text Color', 'qeducato'),
			'subtitle'  => esc_html__('Pick a White text color.', 'qeducato'),
			'default'   => '#fff',
			'output'    => array(
				
				'color'  => '.btn.ss-btn.active,.second-header a, .second-header span,.comment-form .submit,.search-form .search-submit,.wp-block-search .wp-block-search__button,.team-thumb .dropdown .xbtn,#scrollUp,.cta-title h2,.footer-widget .widgettitle, .footer-widget .cat-item, .footer-widget .widget ul li,.copyright-wrap .text,.f-cta-icon i,.btn-style-one'

			)
		),
        array(
			'id'        => 'opt-secondary-color-bakground',
			'type'      => 'color',
			'title'     => esc_html__('Secondary  Color', 'qeducato'),
			'subtitle'  => esc_html__('Pick a background color.', 'qeducato'),
			'default'   => '#125875',
			'output'    => array(
				'background-color' => '.event-item:hover .event-content,.header-three .second-header,.project-detail .info-column .inner-column2 h3,.btn:hover::before,.conterdown,.s-about-content .footer-social a,.about-area .btn',
				'color'            => '',
				'border-color'     => '.about-area .btn,.second-header-btn .btn:hover',
	
			)
		),
         array(
			'id'        => 'opt-threed-color-bakground',
			'type'      => 'color',
			'title'     => esc_html__('Threed  Color', 'qeducato'),
			'subtitle'  => esc_html__('Pick a background color.', 'qeducato'),
			'default'   => '#4ea9b4',
			'output'    => array(
				'background-color' => '.blog-area3 .blog-thumb2 .date-home',
				'color'            => '',
				'border-color'     => '',
	
			)
		),
        array(
			'id'        => 'opt-color-bg-black',
			'type'      => 'color',
			'title'     => esc_html__('Primary Black background Color', 'qeducato'),
			'subtitle'  => esc_html__('Pick a Black background color.', 'qeducato'),
			'default'   => '#232323',
			'output'    => array(
				
				'background-color'  => '.copyright-wrap .text,.btn-style-one',
                'color'            => 'h1, h2, h3, h4, h5, h6'

			)
		),
		
		
      )
    ) );
     //  Typography
    Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'Typography', 'qeducato' ),
      'id'     => 'qeducato__subsection-typography-general',
      'fields' => array(
	  
        
        array(
          'id'          => 'qeducato__custom_body_font',
          'type'        => 'switch',
          'title'       => esc_html__('Customize Body font?', 'qeducato'),
          'subtitle'    => esc_html__('Turn on to use custom fonts for the theme main text.', 'qeducato'),
          'default'     => false,
        ),
        array(
          'id'          => 'qeducato__body-font',
          'type'        => 'typography',
          'title'       => esc_html__('Body font', 'qeducato'),
          'subtitle'    => esc_html__('Specify the Body font properties.', 'qeducato'),
          'google'      => true,
          'output'      => array('body'),
          'units'       => 'px',
          'line-height' => false,
          'text-align'  => false,
          'required'    => array('qeducato__custom_body_font', '=', '1'),
          'default'     => array(
            'color'         => '#6e7b97',
            'font-size'     => '15px',
            'font-family'   => 'Roboto',
            'google'        => true,
            'font-weight'   => '400',
          ),
        ),
        array(
          'id'          => 'qeducato__custom_heading_font',
          'type'        => 'switch',
          'title'       => esc_html__('Customize Headings?', 'qeducato'),
          'subtitle'    => esc_html__('Turn on to use custom fonts, change color, line-height etc. for the theme Headings.', 'qeducato'),
          'default'     => false,
        ),
        array(
          'id'          => 'typography-h1',
          'type'        => 'typography',
          'title'       => esc_html__('H1 Heading', 'qeducato'),
          'subtitle'    => esc_html__('Specify the H1 heading font properties.', 'qeducato'),
          'google'      => true,
          'output'      => array('h1'),
          'units'       => 'px',
          'line-height' => false,
          'text-align'  => false,
          'required'    => array('qeducato__custom_heading_font', '=', '1'),
          'default'     => array(
            'color'         => '#002e5b',
            'font-size'     => '46px',
            'font-family'   => 'Roboto',
            'google'        => true,
            'font-weight'   => '600',
          ),
        ),
        array(
          'id'          => 'typography-h2',
          'type'        => 'typography',
          'title'       => esc_html__('H2 Heading', 'qeducato'),
          'subtitle'    => esc_html__('Specify the H2 heading font properties.', 'qeducato'),
          'google'      => true,
          'output'      => array('h2'),
          'units'       => 'px',
          'line-height' => false,
          'text-align'  => false,
          'required'    => array('qeducato__custom_heading_font', '=', '1'),
          'default'     => array(
            'color'         => '#002e5b',
            'font-size'     => '36px',
            'font-family'   => 'Roboto',
            'google'        => true,
            'font-weight'   => '600',
          ),
        ),
        array(
          'id'          => 'typography-h3',
          'type'        => 'typography',
          'title'       => esc_html__('H3 Heading', 'qeducato'),
          'subtitle'    => esc_html__('Specify the H3 heading font properties.', 'qeducato'),
          'google'      => true,
          'output'      => array('h3'),
          'units'       => 'px',
          'line-height' => false,
          'text-align'  => false,
          'required'    => array('qeducato__custom_heading_font', '=', '1'),
          'default'     => array(
            'color'         => '#002e5b',
            'font-size'     => '28px',
            'font-family'   => 'Roboto',
            'google'        => true,
            'font-weight'   => '600',
          ),
        ),
        array(
          'id'          => 'typography-h4',
          'type'        => 'typography',
          'title'       => esc_html__('H4 Heading', 'qeducato'),
          'subtitle'    => esc_html__('Specify the H4 heading font properties.', 'qeducato'),
          'google'      => true,
          'output'      => array('h4'),
          'units'       => 'px',
          'line-height' => false,
          'text-align'  => false,
          'required'    => array('qeducato__custom_heading_font', '=', '1'),
          'default'     => array(
            'color'         => '#002e5b',
            'font-size'     => '21px',
            'font-family'   => 'Roboto',
            'google'        => true,
            'font-weight'   => '600',
          ),
        ),
        array(
          'id'          => 'typography-h5',
          'type'        => 'typography',
          'title'       => esc_html__('H5 Heading', 'qeducato'),
          'subtitle'    => esc_html__('Specify the H5 heading font properties.', 'qeducato'),
          'google'      => true,
          'output'      => array('h5'),
          'units'       => 'px',
          'line-height' => false,
          'text-align'  => false,
          'required'    => array('qeducato__custom_heading_font', '=', '1'),
          'default'     => array(
            'color'         => '#002e5b',
            'font-size'     => '18px',
            'font-family'   => 'Roboto',
            'google' => true,
            'font-weight'   => '600',
          ),
        ),
        array(
          'id'          => 'typography-h6',
          'type'        => 'typography',
          'title'       => esc_html__('H6 Heading', 'qeducato'),
          'subtitle'    => esc_html__('Specify the H6 heading font properties.', 'qeducato'),
          'google'      => true,
          'output'      => array('h6'),
          'units'       => 'px',
          'line-height' => false,
          'text-align'  => false,
          'required'    => array('qeducato__custom_heading_font', '=', '1'),
          'default'     => array(
            'color'         => '#002e5b',
            'font-size'     => '15px',
            'font-family'   => 'Roboto',
            'google'        => true,
            'font-weight'   => '600',
          ),
        ),
      )
    ) );

	 /////////////////////////////////////////////////footer ///////////////////////////////////////////////
    Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'Theme Footer', 'qeducato' ),
      'id'     => 'qeducato__section-footer',
      'icon'   => 'el el-arrow-down',
      'fields' => array(
      )
    ) );
	

// Footer Text
    Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'Footer Text', 'qeducato' ),
      'id'     => 'qeducato__subsection-footer-text',
      'subsection' => true,
      'fields' => array(
          array(
            'id'        => 'qeducato__opt-footer-text',
            'type'      => 'switch',
            'title'     => esc_html__('Switch', 'qeducato'),
			'default'   => 2,
            'on'        => esc_html__( 'Yes', 'qeducato' ),
            'off'       => esc_html__( 'No', 'qeducato' ),
          ),
          
       )
    ) );


    // Footer Copyright
    Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'Copyright', 'qeducato' ),
      'id'     => 'qeducato__subsection-footer-copyright',
      'subsection' => true,
      'fields' => array(
          array(
            'id'        => 'qeducato__opt-copyright',
            'type'      => 'switch',
            'title'     => esc_html__('Switch', 'qeducato'),
			 'default'   => 2,
            'on'        => esc_html__( 'Yes', 'qeducato' ),
            'off'       => esc_html__( 'No', 'qeducato' ),
          ),
		  array(
              'id'        => 'qeducato__opt-flogo-standard',
              'type'      => 'media',
              'url'       => true,
              'title'     => esc_html__('Footer Logo', 'qeducato'),
              'compiler'  => 'true',
              'desc'      => esc_html__('Upload your image or remove image', 'qeducato'),
              'default'   => array(
                'url'     => get_template_directory_uri() . '/inc/assets/images/logo.png'),
              'required'  => array('qeducato__opt-copyright', '=', '1'),
            ),
          array(
            'id'      => 'qeducato__copyright',
            'type'    => 'text',
            'title'   => esc_html__( 'Copyright Textarea', 'qeducato' ),
			'default'   => 1,
            'default' => '&copy; qeducato All design Zcube. .',
            'required'  => array('qeducato__opt-copyright', '=', '1'),
          ),
          
          array(
            'id'      => 'qeducato__location',
            'type'    => 'textarea',
            'title'   => esc_html__( 'Location Icons', 'qeducato' ),
			'default'   => 1,
            'default' => '&copy; qeducato All design Zcube. .',
            'required'  => array('qeducato__opt-copyright', '=', '1'),
          ),
      )
    ) );
	

    // Footer Widgets
    Redux::setSection( $opt_name, array(
      'title'  => esc_html__( 'Widgets', 'qeducato' ),
      'id'     => 'qeducato__subsection-footer-widgets',
	  'subsection' => true,
      'fields' => array(
        array(
          'id'        => 'qeducato__opt-footer-widgets',
          'type'      => 'switch',
          'title'     => esc_html__('Switch', 'qeducato'),
          'default'   => 2,
          'on'        => 'Show',
          'off'       => 'Hide',
        ),
        array(
          'id'        => 'qeducato__opt-footer-widgets-layout',
          'type'      => 'image_select',
          'compiler'  => true,
          'title'     => esc_html__('Footer Widgets Layout', 'qeducato'),
          'options'   => array(
            '1' => array(
              'alt' => esc_html__( '4 Columns (equal)', 'qeducato' ),
              'img' => get_template_directory_uri() . '/inc/admin/images/footer-cols2.png'),
            '2' => array(
              'alt' => esc_html__('4 Columns', 'qeducato'),
              'img' => get_template_directory_uri() . '/inc/admin/images/footer-cols1.png'),
            '3' => array(
              'alt' => esc_html__( '3 Columns (left wider)', 'qeducato' ),
              'img' => get_template_directory_uri() . '/inc/admin/images/footer-cols3.png'),
            '4' => array(
              'alt' => esc_html__( '3 Columns (right wider)', 'qeducato' ),
              'img' => get_template_directory_uri() . '/inc/admin/images/footer-cols4.png'),
            '5' => array(
              'alt' => esc_html__( '3 Columns (equal)', 'qeducato' ),
              'img' => get_template_directory_uri() . '/inc/admin/images/footer-cols5.png'),
            '6' => array(
              'alt' => esc_html__( '2 Columns (right wider)', 'qeducato' ),
              'img' => get_template_directory_uri() . '/inc/admin/images/footer-cols6.png'),
            '7' => array(
              'alt' => esc_html__( '2 Columns (left wider)', 'qeducato' ),
              'img' => get_template_directory_uri() . '/inc/admin/images/footer-cols7.png'),
          ),
          'default'   => '1',
          'required'  => array('qeducato__opt-footer-widgets', '=', '1'),
        ),
      )
    ) );
    
    /*
     * <--- END SECTIONS--->
     */