<?php

if ( ! defined( 'ABSPATH' ) ) exit;

require_once wp_elementor . '/elementor/traits.php';

class qeducato_Elementor_Integration {

	public $widgets;

	public function __construct()
	{
		$this->widgets = [
            
        'header',
        'footer',
        'header-slider',       
        'header-slider-new',       
        'header-slider-center',       
        'steps',       
        'new-steps',       
        'events',       
        'skill',       
        'features',
        'new-features',        
        'features-two',
        'new-features-two',
        'features-three',
        'new-features-three',
        'about',      
        'courses',      
        'video',      
        'video-two',      
        'our-plans',      
        'newsletter',  
        'service', 
        'service-one', 
        'portfolio', 
        'counter', 
        'team',
        'team-two',     
        'testimonial', 
        'new-testimonial', 
        'testimonial-two', 
        'new-testimonial-two', 
        'testimonial-three', 
        'new-testimonial-three', 
        'support',   
        'blog', 
        'blog-two', 
        'price',
        'faq',  
        'faq-two',  
        'choosse-courses',  
        'scholarship',  
        'brand', 
        'new-brand', 
        'contact-sections',       
        'contact-info',       
        'new-contact-info',       
                
		];
		add_action( 'elementor/init', array( $this, 'widgets_registered' ) );
	}
	public function widgets_registered()
	{
		if ( ! defined( 'ELEMENTOR_PATH' ) || ! class_exists( 'Elementor\Widget_Base' ) || ! class_exists( 'Elementor\Plugin' ) ) {
			return false;
		}

		$elementor = Elementor\Plugin::instance();


		foreach ($this->widgets as $widget) {
			$template_file = wp_elementor . "/elementor/widgets/{$widget}.php";
			if ( file_exists( $template_file ) ) {
				require_once $template_file;
			}
		}
	}
}
new qeducato_Elementor_Integration;