<?php
namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Elementor_about extends Widget_Base
{
	public function get_name()
	{
		return 'Elementor-about-widget';
	}

	public function get_title()
	{
		return __('Zc >  About', 'qeducato');
	}

	public function get_icon()
	{
		return 'eicon-icon-box';
	}

	protected function _register_controls()
	{
		$traits = new \qeducato_Elementor_Traits($this);
		$this->start_controls_section('section_tab', ['label' => esc_html__('Events', 'qeducato'),]);
        
       
        
         $this->add_control(
             
			'about_backgrund_images',

			[

				'label' => esc_html__( 'Background Image' ,'qeducato'),

				'type' => Controls_Manager::MEDIA,
                
                'condition'      => [                    
                'style' =>['style1','style2','style7','style8'],
                ],

			]

			);
        
        $this->add_control(
             
			'main_img',

			[

				'label' => esc_html__( 'Background Image' ,'qeducato'),

				'type' => Controls_Manager::MEDIA,
                
                'condition'      => [                    
                'style' =>['style1','style2','style3','style4','style6','style7','style8'],
                ],

			]

			);
        
        $this->add_control(
             
			'back_img_three',

			[

				'label' => esc_html__( 'Background Image Three' ,'qeducato'),

				'type' => Controls_Manager::MEDIA,
                
                'condition'      => [                    
                'style' =>['style1','style2','style6','style7','style8'],
                ],

			]

			);
            
        $this->add_control(
             
			'back_img_four',

			[

				'label' => esc_html__( 'Background Image Four' ,'qeducato'),

				'type' => Controls_Manager::MEDIA,
                
                'condition'      => [                    
                'style' =>['style1','style2'],
                ],

			]

			);
        
        
          $this->add_control(
             
			'text_heading',

			[

				'label' => esc_html__( 'Text Heading' ,'qeducato'),

				'type' => Controls_Manager::TEXT,
                
                'condition'      => [                    
                  'style' =>['style1','style2','style3','style4','style5','style6','style7','style8'],
                ],

			]

			);
        
        
          $this->add_control(
             
			'sub_heading',

			[

				'label' => esc_html__( 'Sub Heading' ,'qeducato'),

				'type' => Controls_Manager::TEXT,
                
                'condition'      => [                    
                 'style' =>['style1','style2','style3','style4','style5','style6'],
                ],

			]

			);
			
			$this->add_control(
             
			'exp',

			[

				'label' => esc_html__( 'Experience' ,'qeducato'),

				'type' => Controls_Manager::TEXT,
                
                'condition'      => [                    
                 'style' =>['style1','style6'],
                ],

			]

			);
           
		   $this->add_control(
             
			'desc_title',

			[

				'label' => esc_html__( 'Description' ,'qeducato'),

				'type' => Controls_Manager::TEXTAREA,
                
                'condition'      => [                    
                 'style' =>['style1','style2','style3','style4','style6','style7','style8'],
                ],

			]

			);
			
			$this->add_control(
             
			'desc_title1',

			[

				'label' => esc_html__( 'Description 1' ,'qeducato'),

				'type' => Controls_Manager::TEXTAREA,
                
                'condition'      => [                    
                 'style' =>['style1','style2','style4','style6'],
                ],

			]

			);
			$this->add_control(
             
			'button_text',

			[

				'label' => esc_html__( 'Button button_text' ,'qeducato'),

				'type' => Controls_Manager::TEXT,
                
                'condition'      => [                    
                 'style' =>['style1','style2','style3','style4','style5'],
                ],

			]

			);
			$this->add_control(
             
			'button_link',

			[

				'label' => esc_html__( 'Button URL' ,'qeducato'),

				'type' => Controls_Manager::URL,
                
                'condition'      => [                    
                 'style' =>['style1','style2','style3','style4','style5'],
                ],

			]

			);
        
       
        
        $this->add_control(
			'posts_per_page',
			[
				'label'   => esc_html__( 'Number of items to show', 'qeducato' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 6,
			]
		);
        
        
		$this->add_control(
			'style',
			[
				'type' => Controls_Manager::SELECT, 'label' => esc_html__('Choose Style', 'qeducato'), 'default' => 'style1',
				'label_block' => true, 'options' => [
					'style1' =>esc_html__( 'About Style 1', 'qeducato' ),
					'style2' =>esc_html__( 'About Style 2', 'qeducato' ),
					'style3' =>esc_html__( 'About Style 3', 'qeducato' ),
					'style4' =>esc_html__( 'About Style 4', 'qeducato' ),
					'style5' =>esc_html__( 'About Style 5', 'qeducato' ),
					'style6' =>esc_html__( 'About Style 6', 'qeducato' ),
					'style7' =>esc_html__( 'About Step 1', 'qeducato' ),
					'style8' =>esc_html__( 'About Step 2', 'qeducato' ),
				],
			]
		);
		$this->end_controls_section();
	}
	protected function render($instance = [])
	{
		$settings = $this->get_settings();        
                
        $about_backgrund_images = $settings['about_backgrund_images'];
        $main_img = $settings['main_img'];
        $back_img_three = $settings['back_img_three'];
        $back_img_four = $settings['back_img_four'];
        $text_heading = $settings['text_heading'];
        $sub_heading = $settings['sub_heading'];
        $exp = $settings['exp'];
        $desc_title = $settings['desc_title'];
        $desc_title1 = $settings['desc_title1'];
        $button_text = $settings['button_text'];
        $button_link = $settings['button_link'];
        
        
        
        
		$style = $settings['style'];
		switch ($style) {
			case 'style1':
				require get_template_directory() . '/inc/sections/about/style1.php';
				break;
                
            case 'style2':
				require get_template_directory() . '/inc/sections/about/style2.php';
				break;              
          

			case 'style3':
				require get_template_directory() . '/inc/sections/about/style3.php';
				break;
				
			case 'style4':
				require get_template_directory() . '/inc/sections/about/style4.php';
				break;
            
            case 'style5':
				require get_template_directory() . '/inc/sections/about/style5.php';
				break;
                
            case 'style6':
				require get_template_directory() . '/inc/sections/about/style6.php';
				break;
            case 'style7':
				require get_template_directory() . '/inc/sections/about/style7.php';
				break;
            case 'style8':
				require get_template_directory() . '/inc/sections/about/style8.php';
				break;
		}
	}
	protected function content_template() {}
	public function render_plain_content() {}
}

Plugin::instance()->widgets_manager->register_widget_type(new Elementor_about());
