<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_Brand_Box extends Widget_Base {

	public function get_name() {
		return 'Elementor-brand-widget';
	}

	public function get_title() {
		return __( 'Zc >  Brand Box' ,'qeducato' );
	}

	public function get_icon() {
		
		return 'eicon-icon-box';
	}

	protected function _register_controls() {
		$traits = new \qeducato_Elementor_Traits($this);
		
		$this->start_controls_section(
			'services_section',
			['label' => esc_html__( 'Brand','qeducato'),]
		);
        
        
		$this->add_control(
			'service_section',
			[
				'label' => esc_html__( 'Repeator Text','qeducato'),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					
					[                    
						'name' => 'logo_img',
						'label' => esc_html__( 'Logo Image' ,'qeducato' ),
						'type' => Controls_Manager::MEDIA,
					],
                    
                   
                              
				],
			]
		);
         
		$this->end_controls_section();
	}

	protected function render( $instance = [] ) {

		qeducato_el()->get_section('brand', [
            
			'service_section_var' => $this->get_settings('service_section'),
			'column_section_data' => $this->get_settings('column_section'),
          
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_Brand_Box() );