<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_choosse_courses extends Widget_Base {

	public function get_name() {
		return 'Elementor_choosse_courses';
	}

	public function get_title() {
		return esc_html__( 'Zc > Choosse Courses','qeducato');
	}

	public function get_icon() {
		
		 return 'eicon-image-box';
	 }

	protected function _register_controls() {
		$traits = new \qeducato_Elementor_Traits($this);

		$this->start_controls_section(
			'the_why_choose_controls',
			['label' => esc_html__( 'faq_two Section','qeducato'),]
		);
        
         $this->add_control(

			'icon',

			[
				'label' => esc_html__( 'Background Bg' ,'qeducato'),
				'type' => Controls_Manager::MEDIA,
			]

			); 
       
         $this->add_control(

			'text_heading',

			[
				'label' => esc_html__( 'Text Heading' ,'qeducato'),
				'type' => Controls_Manager::TEXT,
			]

			);  
        $this->add_control(

			'decs',

			[
				'label' => esc_html__( 'Description' ,'qeducato'),
				'type' => Controls_Manager::TEXTAREA,
			]

			); 

        
        $this->add_control(

			'shortcode',

			[
				'label' => esc_html__( 'Enter your shortcode' ,'qeducato'),
				'type' => Controls_Manager::TEXTAREA,
			]

			);

		$this->end_controls_section();
	}

	protected function render( $instance = [] ) {


		qeducato_el()->get_section('choosse-courses', [
            'shortcode' => $this->get_settings('shortcode'),
            'decs' => $this->get_settings('decs'),
            'text_heading' => $this->get_settings('text_heading'),
            'icon' => $this->get_settings('icon'),
                   
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_choosse_courses() );
