<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_Contact_Info extends Widget_Base {

	public function get_name() {
		return 'Elementor-contact-info';
	}

	public function get_title() {
		return __( 'Zc >  Contact Info' ,'qeducato' );
	}

	public function get_icon() {
		
		return 'eicon-icon-box';
	}

	protected function _register_controls() {
		$traits = new \qeducato_Elementor_Traits($this);
		
		$this->start_controls_section(
			'services_section',
			['label' => esc_html__( 'Contact Info','qeducato'),]
		);
        $this->add_control(

			'sub_heading',
                [

                    'label' => esc_html__( 'Sub Heading' ,'qeducato'),
                    'type' => Controls_Manager::TEXT,
                ]
			);
        $this->add_control(

			'text_heading',
                [

                    'label' => esc_html__( 'Heading' ,'qeducato'),
                    'type' => Controls_Manager::TEXT,
                ]
			);
        
		$this->add_control(
			'service_section',
			[
				'label' => esc_html__( 'Repeator Text','qeducato'),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					[                    
						'name' => 'class',
						'label' => esc_html__( 'Class Css' ,'qeducato' ),
						'type' => Controls_Manager::TEXT,
					],
					[                    
						'name' => 'icon',
						'label' => esc_html__( 'Icon' ,'qeducato' ),
						'type' => Controls_Manager::MEDIA,
					],
                    
                    [                    
						'name' => 'text',
						'label' => esc_html__( 'Heading' ,'qeducato' ),
						'type' => Controls_Manager::TEXT,
					],
                    
                    [                    
						'name' => 'content',
						'label' => esc_html__( 'Content' ,'qeducato' ),
						'type' => Controls_Manager::TEXTAREA,
					],
                              
				],
			]
		);
         
		$this->end_controls_section();
	}

	protected function render( $instance = [] ) {

		qeducato_el()->get_section('contact-info', [
            
			'service_section_var' => $this->get_settings('service_section'),
			'column_section_data' => $this->get_settings('column_section'),
            'text_heading' => $this->get_settings('text_heading'),
            'sub_heading' => $this->get_settings('sub_heading'),
          
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_Contact_Info() );