<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_faq_two extends Widget_Base {

	public function get_name() {
		return 'Elementor_faq_two';
	}

	public function get_title() {
		return esc_html__( 'Zc > Faq Two','qeducato');
	}

	public function get_icon() {
		
		 return 'eicon-image-box';
	 }

	protected function _register_controls() {
		$traits = new \qeducato_Elementor_Traits($this);

		$this->start_controls_section(
			'the_why_choose_controls',
			['label' => esc_html__( 'faq_two Section','qeducato'),]
		);
        
         $this->add_control(

			'icon',

			[
				'label' => esc_html__( 'Animations Bg' ,'qeducato'),
				'type' => Controls_Manager::MEDIA,
			]

			); 
        $this->add_control(

			'icon_two',

			[
				'label' => esc_html__( 'Animations Bg' ,'qeducato'),
				'type' => Controls_Manager::MEDIA,
			]

			); 
        
         $this->add_control(

			'text_heading',

			[
				'label' => esc_html__( 'Text Heading' ,'qeducato'),
				'type' => Controls_Manager::TEXT,
			]

			);  
        $this->add_control(

			'decs',

			[
				'label' => esc_html__( 'Description' ,'qeducato'),
				'type' => Controls_Manager::TEXTAREA,
			]

			); 

			$this->add_control(

			'service_section',

			[

				'label' => esc_html__( 'Repeator Text','qeducato'),

				'type' => Controls_Manager::REPEATER,

				'fields' => [
                    [

						'name' => 'text-id',

						'label' => esc_html__( 'Tab id ' ,'qeducato' ),

						'type' => Controls_Manager::TEXT,

					],
                    
                     [

						'name' => 'text-class',

						'label' => esc_html__( 'Tab Class ' ,'qeducato' ),

						'type' => Controls_Manager::TEXT,

					],
                    
                     [

						'name' => 'text-class-two',

						'label' => esc_html__( 'Tab Class Two ' ,'qeducato' ),

						'type' => Controls_Manager::TEXT,

					],
						 
					[

						'name' => 'text',

						'label' => esc_html__( 'Text' ,'qeducato' ),

						'type' => Controls_Manager::TEXT,

					],

					[

						'name' => 'content',

						'label' => esc_html__( 'Content','qeducato'),

						'type' => Controls_Manager::TEXTAREA,

					],
					

				],

			]

		);
        $this->add_control(

			'contact_heading',

			[
				'label' => esc_html__( 'Contact Heading' ,'qeducato'),
				'type' => Controls_Manager::TEXT,
			]

			);  
        
        $this->add_control(

			'shortcode',

			[
				'label' => esc_html__( 'Enter your shortcode' ,'qeducato'),
				'type' => Controls_Manager::TEXTAREA,
			]

			);

		$this->end_controls_section();
	}

	protected function render( $instance = [] ) {


		qeducato_el()->get_section('faq-two', [
			'service_section_var' => $this->get_settings('service_section'),
            'shortcode' => $this->get_settings('shortcode'),
            'contact_heading' => $this->get_settings('contact_heading'),
            'decs' => $this->get_settings('decs'),
            'text_heading' => $this->get_settings('text_heading'),
            'icon' => $this->get_settings('icon'),
            'icon_two' => $this->get_settings('icon_two'),
                   
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_faq_two() );
