<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_faq extends Widget_Base {

	public function get_name() {
		return 'Elementor_faq';
	}

	public function get_title() {
		return esc_html__( 'Zc > Faq','qeducato');
	}

	public function get_icon() {
		
		 return 'eicon-image-box';
	 }

	protected function _register_controls() {
		$traits = new \qeducato_Elementor_Traits($this);

		$this->start_controls_section(
			'the_why_choose_controls',
			['label' => esc_html__( 'why_choose Section','qeducato'),]
		);
            $this->add_control(

			'back_img',

                [
                    'label' => esc_html__( 'Background Image' ,'qeducato'),
                    'type' => Controls_Manager::MEDIA,
                ]

			);
        
         $this->add_control(

			'icon_img',

                [
                    'label' => esc_html__( 'Icon Image' ,'qeducato'),
                    'type' => Controls_Manager::MEDIA,
                ]

			);
        
      

        
        $this->add_control(

			'button_link',

                [
                    'label' => esc_html__( 'Video Link' ,'qeducato'),
                    'type' => Controls_Manager::URL,
                ]

			);
			$this->add_control(

			'service_section',

			[

				'label' => esc_html__( 'Repeator Text','qeducato'),

				'type' => Controls_Manager::REPEATER,

				'fields' => [
                    [

						'name' => 'text-id',

						'label' => esc_html__( 'Tab id ' ,'qeducato' ),

						'type' => Controls_Manager::TEXT,

					],
						 
                    [

						'name' => 'text-class',

						'label' => esc_html__( 'Tab Class ' ,'qeducato' ),

						'type' => Controls_Manager::TEXT,

					],
                    
                     [

						'name' => 'text-class-two',

						'label' => esc_html__( 'Tab Class Two ' ,'qeducato' ),

						'type' => Controls_Manager::TEXT,

					],
                    
					[

						'name' => 'text',

						'label' => esc_html__( 'Text' ,'qeducato' ),

						'type' => Controls_Manager::TEXT,

					],

					[

						'name' => 'content',

						'label' => esc_html__( 'Content','qeducato'),

						'type' => Controls_Manager::TEXTAREA,

					],
					

				],

			]

		);

		$this->end_controls_section();
	}

	protected function render( $instance = [] ) {


		qeducato_el()->get_section('faq', [
			'service_section_var' => $this->get_settings('service_section'),
			'back_img' => $this->get_settings('back_img'),
			'icon_img' => $this->get_settings('icon_img'),
			'button_link' => $this->get_settings('button_link'),
                   
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_faq() );
