<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_Widget_header_slider_new extends Widget_Base {

	public function get_name() {
		return 'Elementor-Widget-header-slider-new';
	}

	public function get_title() {
		return esc_html__( 'Zc > New Header Slider', 'qeducato' );
	}

	public function get_icon() {
		return 'eicon-slider-device';
	}

	protected function _register_controls() {
		$traits = new \qeducato_Elementor_Traits($this);
		
		$this->start_controls_section(
			'the_header_slider_section',
			['label' => esc_html__( ' header-Slider','qeducato' ),]
		);
        
        $repeater = new \Elementor\Repeater();
        
         $repeater->add_control(
            'hero_image', [
                'label' => esc_html__( 'Slide Background Image', 'qeducato' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => plugin_dir_url( __DIR__ ).'assets/img/slide1.jpg',
                ],
            ]
        );
        $repeater->add_control(
            'hero_subtitle',
            [
                'label' => esc_html__( 'Sub Heading Text', 'qeducato' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'Welcome <span>Insureyou</span>',
            ]
        );
        $repeater->add_control(
            'hero_heading',
            [
                'label' => esc_html__( 'Heading Text', 'qeducato' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'Get <span>Insurance</span> For Anything You Need',
            ]
        );
        
         $repeater->add_control(
            'hero_description',
            [
                'label' => esc_html__( 'Description Text', 'qeducato' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'Donec vitae libero non enim placerat eleifend aliquam erat volutpat. Curabitur diam ex, dapibus purus sapien, cursus sed nisl tristique, commodo gravida lectus non.',
            ]
        );
        $repeater->add_control(
            'button_text',
            [
                'label' => esc_html__( 'Button Title', 'qeducato' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'View Causes',                
            ]
        );

        $repeater->add_control(
            'button_link',
            [
                'label' => esc_html__( 'Button Link', 'qeducato' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'placeholder' => __( 'https://', 'qeducato' ),
                'default' => [
                    'url' => '#',
                ],
            ]
        );

        $repeater->add_control(
            'button_text_two',
            [
                'label' => esc_html__( 'Button Title Two', 'qeducato' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'View Causes',                
            ]
        );

        $repeater->add_control(
            'button_link_two',
            [
                'label' => esc_html__( 'Button Link Two', 'qeducato' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'placeholder' => __( 'https://', 'qeducato' ),
                'default' => [
                    'url' => '#',
                ],
            ]
        );

        $this->add_control(
            'hero_slides',
            [
                'label' => esc_html__( 'All Slides', 'qeducato' ),
                'type' =>Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'hero_image' => [
                            'url' => plugin_dir_url( __DIR__ ).'assets/img/slide1.jpg',
                        ],
                        'hero_heading'   => 'Get <span>Insurance</span> For Anything You Need',
                    ],
                   
                ],
                'title_field' => '{{{hero_heading}}}'
            ]
        );


		$this->end_controls_section();
	}

	protected function render( $instance = [] ) {

		qeducato_el()->get_section('header-slider-new', [
            'hero_slides' => $this->get_settings('hero_slides'),
			
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_Widget_header_slider_new() );