<?php
namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Elementor_Header extends Widget_Base
{
	public function get_name()
	{
		return 'Elementor-Header-widget';
	}

	public function get_title()
	{
		return __('Zc >  Header', 'qeducato');
	}

	public function get_icon()
	{
		return 'eicon-icon-box';
	}

	protected function _register_controls()
	{
		$traits = new \qeducato_Elementor_Traits($this);
		$this->start_controls_section('section_tab', ['label' => esc_html__('Header', 'qeducato'),]);
        
       
         
         $this->add_control(
             
			'back_img',

			[

				'label' => esc_html__( 'Background Image' ,'qeducato'),

				'type' => Controls_Manager::MEDIA,
                
                'condition'      => [                    
                'style' =>['style1','style2'],
                ],

			]

			);
        
        $this->add_control(
             
			'back_img_two',

			[

				'label' => esc_html__( 'Background Image Two' ,'qeducato'),

				'type' => Controls_Manager::MEDIA,
                
                'condition'      => [                    
                'style' =>['style1'],
                ],

			]

			);
        
        $this->add_control(
             
			'back_img_three',

			[

				'label' => esc_html__( 'Background Image Three' ,'qeducato'),

				'type' => Controls_Manager::MEDIA,
                
                'condition'      => [                    
                'style' =>['style1'],
                ],

			]

			);
            
        $this->add_control(
             
			'back_img_four',

			[

				'label' => esc_html__( 'Background Image Four' ,'qeducato'),

				'type' => Controls_Manager::MEDIA,
                
                'condition'      => [                    
                'style' =>['style1'],
                ],

			]

			);
        
        $this->add_control(
             
			'header_backgrund_images',

			[

				'label' => esc_html__( 'Background Image Five' ,'qeducato'),

				'type' => Controls_Manager::MEDIA,
                
                'condition'      => [                    
                'style' =>['style1','style2'],
                ],

			]

			);
        
        
          $this->add_control(
             
			'text_heading',

			[

				'label' => esc_html__( 'Text Heading' ,'qeducato'),

				'type' => Controls_Manager::TEXT,
                
                'condition'      => [                    
                  'style' =>['style1','style2'],
                ],

			]

			);
        
        
          $this->add_control(
             
			'sub_heading',

			[

				'label' => esc_html__( 'Sub Heading' ,'qeducato'),

				'type' => Controls_Manager::TEXT,
                
                'condition'      => [                    
                 'style' =>['style1','style2'],
                ],

			]

			);
        
        $this->add_control(
             
			'desc_title',

			[

				'label' => esc_html__( 'Desc title' ,'qeducato'),

				'type' => Controls_Manager::TEXTAREA,
                
                'condition'      => [                    
                 'style' =>['style1','style2'],
                ],

			]

			);
        
        
           $this->add_control(
             
			'button_text',

			[

				'label' => esc_html__( 'Button Text' ,'qeducato'),

				'type' => Controls_Manager::TEXT,
                
                'condition'      => [                    
                 'style' =>['style1','style2'],
                ],

			]

			);
        
        $this->add_control(
             
			'button_link',

			[

				'label' => esc_html__( 'Button Link' ,'qeducato'),

				'type' => Controls_Manager::URL,
                
                'condition'      => [                    
                 'style' =>['style1','style2'],
                ],

			]

			);
        
       
        
		$this->add_control(
			'style',
			[
				'type' => Controls_Manager::SELECT, 'label' => esc_html__('Choose Style', 'qeducato'), 'default' => 'style1',
				'label_block' => true, 'options' => [
					'style1' => esc_html__('Header style 01', 'qeducato'), 
					'style2' => esc_html__('Header style 02', 'qeducato'), 
				],
			]
		);
		$this->end_controls_section();
	}
	protected function render($instance = [])
	{
		$settings = $this->get_settings();        
                
        $back_img = $settings['back_img'];
        $back_img_two = $settings['back_img_two'];
        $back_img_three = $settings['back_img_three'];
        $back_img_four = $settings['back_img_four'];
        $header_backgrund_images = $settings['header_backgrund_images'];
        $text_heading = $settings['text_heading'];
        $sub_heading = $settings['sub_heading'];
        $desc_title = $settings['desc_title'];
        $button_text = $settings['button_text'];
        $button_link = $settings['button_link'];
        
        
        
        
		$style = $settings['style'];
		switch ($style) {
			case 'style1':
				require get_template_directory() . '/inc/sections/header/style1.php';
				break;
                
            case 'style2':
				require get_template_directory() . '/inc/sections/header/style2.php';
				break;              
        
		}
	}
	protected function content_template() {}
	public function render_plain_content() {}
}

Plugin::instance()->widgets_manager->register_widget_type(new Elementor_Header());
