<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_new_Brand_Box extends Widget_Base {

	public function get_name() {
		return 'Elementor-new-brand-widget';
	}

	public function get_title() {
		return __( 'Zc > New Brand Box' ,'qeducato' );
	}

	public function get_icon() {
		
		return 'eicon-icon-box';
	}

	protected function _register_controls() {
		$traits = new \qeducato_Elementor_Traits($this);
		
		$this->start_controls_section(
			'services_section',
			['label' => esc_html__( 'Brand','qeducato'),]
		);
        
         $repeater = new \Elementor\Repeater();
          
           $repeater->add_control(
            'brand_icon', [
                'label' => esc_html__( 'Feature img', 'qeducato' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => plugin_dir_url( __DIR__ ).'assets/img/slide1.jpg',
                ],
            ]
            );
            $this->add_control(
                'brand_slides',
                [
                    'label' => esc_html__( 'All Slides', 'qeducato' ),
                    'type' =>Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'default' => [
                        [
                            'brand_icon' => [
                                'url' => plugin_dir_url( __DIR__ ).'assets/img/slide1.jpg',
                            ],
                            'brand_icon'   => 'Subhan',
                        ],

                    ],
                    'title_field' => '{{{brand_icon}}}'
                ]
            );
        

         
		$this->end_controls_section();
	}

	protected function render( $instance = [] ) {

		qeducato_el()->get_section('new-brand', [
            
			'brand_slides' => $this->get_settings('brand_slides'),
			'column_section_data' => $this->get_settings('column_section'),
          
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_new_Brand_Box() );