<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_new_Contact_Info extends Widget_Base {

	public function get_name() {
		return 'Elementor-new-contact-info';
	}

	public function get_title() {
		return __( 'Zc > New Contact Info' ,'qeducato' );
	}

	public function get_icon() {
		
		return 'eicon-icon-box';
	}

	protected function _register_controls() {
		$traits = new \qeducato_Elementor_Traits($this);
		
		$this->start_controls_section(
			'services_section',
			['label' => esc_html__( 'Contact Info','qeducato'),]
		);
        $this->add_control(

			'sub_heading',
                [

                    'label' => esc_html__( 'Sub Heading' ,'qeducato'),
                    'type' => Controls_Manager::TEXT,
                ]
			);
        $this->add_control(

			'text_heading',
                [

                    'label' => esc_html__( 'Heading' ,'qeducato'),
                    'type' => Controls_Manager::TEXT,
                ]
			);
        
         $repeater = new \Elementor\Repeater();
          
           $repeater->add_control(
            'contact_icon', [
                'label' => esc_html__( 'Feature img', 'qeducato' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => plugin_dir_url( __DIR__ ).'assets/img/slide1.jpg',
                ],
            ]
            );         
            $repeater->add_control(
                'contact_class',
                [
                    'label' => esc_html__( 'Class', 'qeducato' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            
            $repeater->add_control(
                'contact_heading',
                [
                    'label' => esc_html__( 'Heading Text', 'qeducato' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default' => 'Subhan',
                ]
            );
            
          
             $repeater->add_control(
                'contact_description',
                [
                    'label' => esc_html__( 'Description Text', 'qeducato' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                    'default' => 'Donec vitae libero non enim placerat eleifend aliquam erat volutpat. Curabitur diam ex, dapibus purus sapien, cursus sed nisl tristique, commodo gravida lectus non.',
                ]
            );
         

           
            $this->add_control(
                'contact_slides',
                [
                    'label' => esc_html__( 'All Slides', 'qeducato' ),
                    'type' =>Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'default' => [
                        [
                            'contact_icon' => [
                                'url' => plugin_dir_url( __DIR__ ).'assets/img/slide1.jpg',
                            ],
                            'contact_heading'   => 'Subhan',
                        ],

                    ],
                    'title_field' => '{{{contact_heading}}}'
                ]
            );
     
         
		$this->end_controls_section();
	}

	protected function render( $instance = [] ) {

		qeducato_el()->get_section('new-contact-info', [
            
			'contact_slides' => $this->get_settings('contact_slides'),
			'column_section_data' => $this->get_settings('column_section'),
            'text_heading' => $this->get_settings('text_heading'),
            'sub_heading' => $this->get_settings('sub_heading'),
          
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_new_Contact_Info() );