<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_new_features_three_box extends Widget_Base {

	public function get_name() {
		return 'Elementor-new-features-three-widget';
	}

	public function get_title() {
		return __( 'Zc > New Features Box Three' ,'qeducato' );
	}

	public function get_icon() {
		
		return 'eicon-icon-box';
	}

	protected function _register_controls() {
		$traits = new \qeducato_Elementor_Traits($this);
		
		$this->start_controls_section(
			'services_section',
			['label' => esc_html__( 'Features','qeducato'),]
		);
        
        $this->add_control(

			'text_heading',
			[
				'label' => esc_html__( 'Text Heading' ,'qeducato'),
				'type' => Controls_Manager::TEXT,
			]
			);
        
        $repeater = new \Elementor\Repeater();
          
           $repeater->add_control(
            'feature_icon', [
                'label' => esc_html__( 'Feature img', 'qeducato' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => plugin_dir_url( __DIR__ ).'assets/img/slide1.jpg',
                ],
            ]
            );
            $repeater->add_control(
                'feature_class',
                [
                    'label' => esc_html__( 'Class', 'qeducato' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $repeater->add_control(
                'feature_heading',
                [
                    'label' => esc_html__( 'Heading Text', 'qeducato' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                    'default' => 'Get <span>Insurance</span> For Anything You Need',
                ]
            );

             $repeater->add_control(
                'feature_description',
                [
                    'label' => esc_html__( 'Description Text', 'qeducato' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                    'default' => 'Donec vitae libero non enim placerat eleifend aliquam erat volutpat. Curabitur diam ex, dapibus purus sapien, cursus sed nisl tristique, commodo gravida lectus non.',
                ]
            );
           
            $repeater->add_control(
                'button_link',
                [
                    'label' => esc_html__( 'Button Link', 'qeducato' ),
                    'type' => Controls_Manager::URL,
                    'label_block' => true,
                    'placeholder' => __( 'https://', 'qeducato' ),
                    'default' => [
                        'url' => '#',
                    ],
                ]
            );

           
            $this->add_control(
                'feature_slides',
                [
                    'label' => esc_html__( 'All Slides', 'qeducato' ),
                    'type' =>Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'default' => [
                        [
                            'feature_icon' => [
                                'url' => plugin_dir_url( __DIR__ ).'assets/img/slide1.jpg',
                            ],
                            'hero_heading'   => 'Get <span>Insurance</span> For Anything You Need',
                        ],

                    ],
                    'title_field' => '{{{feature_heading}}}'
                ]
            );
        
		$this->end_controls_section();
	}

	protected function render( $instance = [] ) {

		qeducato_el()->get_section('new-features-three', [
            
			'feature_slides' => $this->get_settings('feature_slides'),
            'text_heading' => $this->get_settings('text_heading'),
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_new_features_three_box() );