<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_new_steps_Box extends Widget_Base {

	public function get_name() {
		return 'Elementor-new-steps-widget';
	}

	public function get_title() {
		return __( 'Zc > New Steps Box' ,'qeducato' );
	}

	public function get_icon() {
		
		return 'eicon-icon-box';
	}

	protected function _register_controls() {
		$traits = new \qeducato_Elementor_Traits($this);
		
		$this->start_controls_section(
			'services_section',
			['label' => esc_html__( 'Skill','qeducato'),]
		);
        
        
        $this->add_control(

			'feature_img',

			[
				'label' => esc_html__( 'Feature Image' ,'qeducato'),
				'type' => Controls_Manager::MEDIA,

			]
			);  
        
        $this->add_control(

			'icon_img',

			[
				'label' => esc_html__( 'Icon Image' ,'qeducato'),
				'type' => Controls_Manager::MEDIA,

			]
			);  
        
        $this->add_control(

			'text_heading',

			[
				'label' => esc_html__( 'Text Heading' ,'qeducato'),
				'type' => Controls_Manager::TEXT,

			]
			);  
        
    
        
        $this->add_control(

			'desc',

			[
				'label' => esc_html__( 'Description' ,'qeducato'),
				'type' => Controls_Manager::TEXTAREA,

			]
			);  
        
        
         $repeater = new \Elementor\Repeater();
          
           $repeater->add_control(
            'setp_icon', [
                'label' => esc_html__( 'Feature img', 'qeducato' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => plugin_dir_url( __DIR__ ).'assets/img/slide1.jpg',
                ],
            ]
            );
          
            $repeater->add_control(
                'setp_heading',
                [
                    'label' => esc_html__( 'Heading Text', 'qeducato' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                    'default' => 'Get <span>Insurance</span> For Anything You Need',
                ]
            );

             $repeater->add_control(
                'setp_description',
                [
                    'label' => esc_html__( 'Description Text', 'qeducato' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                    'default' => 'Donec vitae libero non enim placerat eleifend aliquam erat volutpat. Curabitur diam ex, dapibus purus sapien, cursus sed nisl tristique, commodo gravida lectus non.',
                ]
            );
         

           
            $this->add_control(
                'setp_slides',
                [
                    'label' => esc_html__( 'All Slides', 'qeducato' ),
                    'type' =>Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'default' => [
                        [
                            'setp_icon' => [
                                'url' => plugin_dir_url( __DIR__ ).'assets/img/slide1.jpg',
                            ],
                            'setp_heading'   => 'Skilled Teachers',
                        ],

                    ],
                    'title_field' => '{{{setp_heading}}}'
                ]
            );

        

		$this->end_controls_section();
	}

	protected function render( $instance = [] ) {

		qeducato_el()->get_section('new-steps', [
            
			'setp_slides' => $this->get_settings('setp_slides'),
			'feature_img' => $this->get_settings('feature_img'),
			'icon_img' => $this->get_settings('icon_img'),
			'text_heading' => $this->get_settings('text_heading'),
			'desc' => $this->get_settings('desc'),
          
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_new_steps_Box() );