<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_new_testimonial_two extends Widget_Base {

	public function get_name() {
		return 'Elementor-new-testimonial-two';
	}

	public function get_title() {
		return esc_html__( 'Zc > New Testimonial Two' ,'qeducato' );
	}

	public function get_icon() {
		
		return 'eicon-icon-box';
	}

	protected function _register_controls() {
		$traits = new \qeducato_Elementor_Traits($this);
		
		$this->start_controls_section(
			'services_section',
			['label' => esc_html__( 'New Testimonials Two','qeducato'),]
		);
        
        
         $this->add_control(

            'back_img',

            [
                'label' => esc_html__( 'Background Image' ,'qeducato'),
                'type' => Controls_Manager::MEDIA,
            ]
            );
        
        $this->add_control(

            'icon_img',

            [
                'label' => esc_html__( 'Icon' ,'qeducato'),
                'type' => Controls_Manager::MEDIA,
            ]
            );
        
         $repeater = new \Elementor\Repeater();
          
           $repeater->add_control(
            'testimonial_icon', [
                'label' => esc_html__( 'Feature img', 'qeducato' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => plugin_dir_url( __DIR__ ).'assets/img/slide1.jpg',
                ],
            ]
            );
          
          
            
            $repeater->add_control(
                'testimonial_name',
                [
                    'label' => esc_html__( 'Name Text', 'qeducato' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default' => 'Subhan',
                ]
            );
            
            $repeater->add_control(
                'testimonial_position',
                [
                    'label' => esc_html__( 'Position Text', 'qeducato' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default' => 'Web Developer',
                ]
            );
        
             $repeater->add_control(
                'testimonial_description',
                [
                    'label' => esc_html__( 'Description Text', 'qeducato' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                    'default' => 'Donec vitae libero non enim placerat eleifend aliquam erat volutpat. Curabitur diam ex, dapibus purus sapien, cursus sed nisl tristique, commodo gravida lectus non.',
                ]
            );
         

           
            $this->add_control(
                'testimonial_slides',
                [
                    'label' => esc_html__( 'All Slides', 'qeducato' ),
                    'type' =>Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'default' => [
                        [
                            'testimonial_icon' => [
                                'url' => plugin_dir_url( __DIR__ ).'assets/img/slide1.jpg',
                            ],
                            'testimonial_name'   => 'Subhan',
                        ],

                    ],
                    'title_field' => '{{{testimonial_name}}}'
                ]
            );
        
         
		$this->end_controls_section();
		
	}

	protected function render( $instance = [] ) {

		qeducato_el()->get_section('new-testimonial-two', [
            
			'testimonial_slides' => $this->get_settings('testimonial_slides'), 
			'column_section_data' => $this->get_settings('column_section'),
			'hading_section_data' => $this->get_settings('heading-text'),
			'back_img' => $this->get_settings('back_img'),
			'test_img' => $this->get_settings('test_img'),
            'icon_img' => $this->get_settings('icon_img'),                          
          
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_new_testimonial_two() );