<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_newsletter_box extends Widget_Base {

	public function get_name() {
		return 'Elementor-newsletter-widget';
	}

	public function get_title() {
		return __( 'Zc >  Newsletter Box' ,'qeducato' );
	}

	public function get_icon() {
		
		return 'eicon-icon-box';
	}

	protected function _register_controls() {
		$traits = new \qeducato_Elementor_Traits($this);
		
		$this->start_controls_section(
			'services_section',
			['label' => esc_html__( 'Newsletter','qeducato'),]
		);
        
        $this->add_control(

			'back_img',
            
                [

                    'label' => esc_html__( 'Background Image' ,'qeducato'),
                    'type' => Controls_Manager::MEDIA,
                ]
			);
       
        $this->add_control(

			'text_heading',
            
                [

                    'label' => esc_html__( 'Top Heading' ,'qeducato'),
                    'type' => Controls_Manager::TEXT,
                ]
			);
        
        $this->add_control(

			'desc',
            
                [

                    'label' => esc_html__( 'Description' ,'qeducato'),
                    'type' => Controls_Manager::TEXTAREA,
                ]
			);
        
          $this->add_control(

			'shortcode_newsletter',
              
                [

                    'label' => esc_html__( 'Shortcode' ,'qeducato'),
                    'type' => Controls_Manager::TEXTAREA,
                ]
			);
        
		$this->end_controls_section();
	}

	protected function render( $instance = [] ) {

		qeducato_el()->get_section('newsletter', [
            
			'back_img' => $this->get_settings('back_img'),
			'text_heading' => $this->get_settings('text_heading'),
			'desc' => $this->get_settings('desc'),
			'shortcode_newsletter' => $this->get_settings('shortcode_newsletter'),
           
          
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_newsletter_box() );