<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_price_icon_widget extends Widget_Base {

	public function get_name() {
		return 'Elementor-price-icon';
	}

	public function get_title() {
		return esc_html__( 'Zc > Price' ,'qeducato');
	}

	public function get_icon() {
		
		return 'eicon-price-table';
	}

	protected function _register_controls() {
		$traits = new \qeducato_Elementor_Traits($this);
		
		$this->start_controls_section(
			'price-icon-control',
			['label' => esc_html__( 'Price Section','qeducato'),]
		);
        
          $this->add_control(

			'text_heading',
			[
				'label' => esc_html__( 'Text Heading' ,'qeducato'),
				'type' => Controls_Manager::TEXT,
			]
			);
		$this->add_control(
			'Repeator',
			[
				'label' => esc_html__( 'Price Icon','qeducato'),
				'type' => Controls_Manager::REPEATER,
				'fields' =>array_merge([
                    
                  [
						'name' => 'active_changer',
					   'label' => esc_html__( 'active', 'qeducato'),
					   'type' => Controls_Manager::SELECT2,
					   'default' => 'd-active',
					   'options' => [
						'd-active' => esc_html__( 'D-Active', 'qeducato'),
						'active' => esc_html__( 'Active', 'qeducato'),

                        ],

                    ],

                   [
                        'name' => 'text',
                        'label' => esc_html__( 'Text' ,'qeducato' ),
                        'type' => Controls_Manager::TEXT,

                    ],	
				
				
                    [
						'name' => 'price',
						'label' => esc_html__( 'price','qeducato'),
						'type' => Controls_Manager::TEXT,
					],
				    
                     [
						'name' => 'price_text',
						'label' => esc_html__( 'Price Text','qeducato'),
						'type' => Controls_Manager::TEXTAREA,
					],
                    
                    [
						'name' => 'content',
						'label' => esc_html__( 'content' ,'qeducato'),
						'type' => Controls_Manager::TEXTAREA,
					],
                    
					[

						'name' => 'price-button',

						'label' => esc_html__( 'Price Button Text' ,'qeducato'),

						'type' => Controls_Manager::TEXT,

					],
					
					[

						'name' => 'price-button-link',

						'label' => esc_html__( 'url' ,'qeducato'),

						'type' => Controls_Manager::URL,

						'default' => [

							'url' => '',

							'is_external' => true,

						],

						'show_external' => false,

						'separator' => 'after',

					],
					
				]),
			]
		);
         
		$this->end_controls_section();
		
	}

	protected function render( $instance = [] ) {

		qeducato_el()->get_section('price', [
            
			'Repeators' => $this->get_settings('Repeator'),
            'text_heading' => $this->get_settings('text_heading'),
	       
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_price_icon_widget() );