<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_Scholarship_Box extends Widget_Base {

	public function get_name() {
		return 'Elementor-scholarship-widget';
	}

	public function get_title() {
		return __( 'Zc >  Scholarship Box' ,'qeducato' );
	}

	public function get_icon() {
		
		return 'eicon-icon-box';
	}

	protected function _register_controls() {
		$traits = new \qeducato_Elementor_Traits($this);
		
		$this->start_controls_section(
			'services_section',
			['label' => esc_html__( 'Skill','qeducato'),]
		);
        
        
        $this->add_control(

			'feature_img',

			[
				'label' => esc_html__( 'Feature Image' ,'qeducato'),
				'type' => Controls_Manager::MEDIA,

			]
			);  
        
        $this->add_control(

			'text_heading',

			[
				'label' => esc_html__( 'Text Heading' ,'qeducato'),
				'type' => Controls_Manager::TEXT,

			]
			);  
        
    
        
        $this->add_control(

			'desc',

			[
				'label' => esc_html__( 'Description' ,'qeducato'),
				'type' => Controls_Manager::TEXTAREA,

			]
			);  
    
        $this->add_control(

			'button-text',
			[
				'label' => esc_html__( 'Button Text' ,'qeducato'),
				'type' => Controls_Manager::TEXT,
			]
			);
			
            $this->add_control(

			'button-link',
			[
				'label' => esc_html__( 'Button Url' ,'qeducato'),
				'type' => Controls_Manager::URL,
			]
			);
        
	
         
		$this->end_controls_section();
	}

	protected function render( $instance = [] ) {

		qeducato_el()->get_section('scholarship', [
            
			'button-text' => $this->get_settings('button-text'),
			'button-link' => $this->get_settings('button-link'),
			'feature_img' => $this->get_settings('feature_img'),
			'text_heading' => $this->get_settings('text_heading'),
			'desc' => $this->get_settings('desc'),
          
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_Scholarship_Box() );