<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_Skill_Box extends Widget_Base {

	public function get_name() {
		return 'Elementor-skill-widget';
	}

	public function get_title() {
		return __( 'Zc >  Skill Box' ,'qeducato' );
	}

	public function get_icon() {
		
		return 'eicon-icon-box';
	}

	protected function _register_controls() {
		$traits = new \qeducato_Elementor_Traits($this);
		
		$this->start_controls_section(
			'services_section',
			['label' => esc_html__( 'Skill','qeducato'),]
		);
        
        
        
        $this->add_control(

			'icon_img',

			[
				'label' => esc_html__( 'Feature Image' ,'qeducato'),
				'type' => Controls_Manager::MEDIA,

			]
			);  
        
        $this->add_control(

			'text_heading',

			[
				'label' => esc_html__( 'Text Heading' ,'qeducato'),
				'type' => Controls_Manager::TEXT,

			]
			);  
        
    
        
        $this->add_control(

			'desc',

			[
				'label' => esc_html__( 'Description' ,'qeducato'),
				'type' => Controls_Manager::TEXTAREA,

			]
			);  
    
        
        
		$this->add_control(
			'service_section',
			[
				'label' => esc_html__( 'Repeator Text','qeducato'),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					
                    [                    
						'name' => 'text',
						'label' => esc_html__( 'Heading' ,'qeducato' ),
						'type' => Controls_Manager::TEXT,
					],
                    
                    [                    
						'name' => 'increment',
						'label' => esc_html__( 'Increment' ,'qeducato' ),
						'type' => Controls_Manager::TEXT,
					],
                              
				],
			]
		);
         
		$this->end_controls_section();
	}

	protected function render( $instance = [] ) {

		qeducato_el()->get_section('skill', [
            
			'service_section_var' => $this->get_settings('service_section'),
			'icon_img' => $this->get_settings('icon_img'),
			'text_heading' => $this->get_settings('text_heading'),
			'desc' => $this->get_settings('desc'),
          
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_Skill_Box() );