<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_testimonial_two extends Widget_Base {

	public function get_name() {
		return 'Elementor-testimonial-two';
	}

	public function get_title() {
		return esc_html__( 'Zc >  Testimonial Two' ,'qeducato' );
	}

	public function get_icon() {
		
		return 'eicon-icon-box';
	}

	protected function _register_controls() {
		$traits = new \qeducato_Elementor_Traits($this);
		
		$this->start_controls_section(
			'services_section',
			['label' => esc_html__( 'Testimonials Two','qeducato'),]
		);
        
        
         $this->add_control(

            'back_img',

            [
                'label' => esc_html__( 'Background Image' ,'qeducato'),
                'type' => Controls_Manager::MEDIA,
            ]
            );
        
        $this->add_control(

            'icon_img',

            [
                'label' => esc_html__( 'Icon' ,'qeducato'),
                'type' => Controls_Manager::MEDIA,
            ]
            );
        
         				
		$this->add_control(
			'service_section',
			[
				'label' => esc_html__( 'Repeator Text','qeducato'),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
				   
                  [
						'name' => 'features_img',
						'label' => esc_html__( 'features Image','qeducato'),
						'type' => Controls_Manager::MEDIA,
					],
					
					[
					    'name' => 'features_img_switcher',
						'label' => esc_html__( 'features Image Switcher','qeducato'  ),
						'type' => Controls_Manager::SWITCHER,
						'default' => 'yes',
						'label_on' => esc_html__( 'Show','qeducato' ),
						'label_off' => esc_html__( 'Hide','qeducato'  ),
						'return_value' => 'yes',
					],
                    
                     [
						'name' => 'text',
						'label' => esc_html__( 'Text' ,'qeducato' ),
						'type' => Controls_Manager::TEXT,
					],
					
                    [
						'name' => 'name',
						'label' => esc_html__( 'name' ,'qeducato' ),
						'type' => Controls_Manager::TEXT,
					],
                    
                    [
						'name' => 'position',
						'label' => esc_html__( 'Position' ,'qeducato' ),
						'type' => Controls_Manager::TEXT,
					],
                    
                    [
						'name' => 'content',
						'label' => esc_html__( 'Content' ,'qeducato' ),
						'type' => Controls_Manager::TEXTAREA,
					],
                    
				],
			]
		);
         
		$this->end_controls_section();
		
	}

	protected function render( $instance = [] ) {

		qeducato_el()->get_section('testimonial-two', [
            
			'service_section_var' => $this->get_settings('service_section'), 
			'column_section_data' => $this->get_settings('column_section'),
			'hading_section_data' => $this->get_settings('heading-text'),
			'back_img' => $this->get_settings('back_img'),
			'test_img' => $this->get_settings('test_img'),
            'icon_img' => $this->get_settings('icon_img'),                          
          
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_testimonial_two() );