<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Elementor_video extends Widget_Base {

	public function get_name() {
		return 'Elementor_video';
	}

	public function get_title() {
		return esc_html__( 'Zc > Video','qeducato');
	}

	public function get_icon() {
		
		 return 'eicon-image-box';
	 }

	protected function _register_controls() {
		$traits = new \qeducato_Elementor_Traits($this);

		$this->start_controls_section(
			'the_why_choose_controls',
			['label' => esc_html__( 'Video','qeducato'),]
		);
        
         $this->add_control(

			'back_img',

                [
                    'label' => esc_html__( 'Background Image' ,'qeducato'),
                    'type' => Controls_Manager::MEDIA,
                ]

			);
        
         $this->add_control(

			'icon_img',

                [
                    'label' => esc_html__( 'Icon Image' ,'qeducato'),
                    'type' => Controls_Manager::MEDIA,
                ]

			);
        
      
       $this->add_control(

			'heading_text',

                [
                    'label' => esc_html__( 'Heading Text' ,'qeducato'),
                    'type' => Controls_Manager::TEXT,
                ]

			);
        $this->add_control(

			'decs',

			[
				'label' => esc_html__( 'Description' ,'qeducato'),
				'type' => Controls_Manager::TEXTAREA,
			]

			); 
        
        $this->add_control(

			'button_link',

                [
                    'label' => esc_html__( 'Video Link' ,'qeducato'),
                    'type' => Controls_Manager::URL,
                ]

			);

		$this->end_controls_section();
	}

	protected function render( $instance = [] ) {


		qeducato_el()->get_section('video', [
            
			'back_img' => $this->get_settings('back_img'),
			'icon_img' => $this->get_settings('icon_img'),
			'decs' => $this->get_settings('decs'),
			'button_link' => $this->get_settings('button_link'),
			'heading_text' => $this->get_settings('heading_text'),
                   
			]);
	}

	protected function content_template() {}

	public function render_plain_content() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Elementor_video() );
