<?php
/**
 * Post metaboxes configuration
 *
 * @package  qeducato.
 */

add_filter( 'rwmb_meta_boxes', 'qeducatozc_register_meta_boxes' );
function qeducatozc_register_meta_boxes( $meta_boxes ) {
    $prefix = 'qeducatozc_';
	$meta_boxes[] = array(
        'id'         => 'Quote',
        'title'      => esc_html__( 'Post Quote', 'qeducato' ),
        'post_types' => 'post',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Quote', 'qeducato' ),
                'desc'  => esc_html__( 'Quote Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_quote',
                 'type'    => 'textarea',
            ),
        )
    );
	$meta_boxes[] = array(
        'id'         => 'Link',
        'title'      => esc_html__( 'Post Link', 'qeducato' ),
        'post_types' => 'post',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Link', 'qeducato' ),
                'desc'  => esc_html__( 'Link Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_link',
                 'type'    => 'text',
            ),
        )
    );
    $meta_boxes[] = array(
        'id'         => 'blog-sections',
        'title'      => esc_html__( 'Post Gallery', 'qeducato' ),
        'post_types' => 'post',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(
            array(
                'name'  => esc_html__( 'Gallery', 'qeducato' ),
                'desc'  => '',
                'id'    => $prefix . 'post_gallery',
                'type'             => 'image_advanced',

				// Delete file from Media Library when remove it from post meta?
				// Note: it might affect other posts if you use same file for multiple posts
				'force_delete'     => false,

				// Maximum file uploads.
				'max_file_uploads' => 10,

				// Do not show how many files uploaded/remaining.
				'max_status'       => 'false',

				// Image size that displays in the edit page.
				'image_size'       => 'thumbnail',
            ),
			
        )
    );
	$meta_boxes[] = array(
        'id'         => 'video-sections',
        'title'      => esc_html__( 'Post Video', 'qeducato' ),
        'post_types' => 'post',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Video', 'qeducato' ),
                'desc'  => esc_html__( 'Youtube & Viemo Url Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_video',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
        )
    );
	$meta_boxes[] = array(
        'id'         => 'audio-sections',
        'title'      => esc_html__( 'Post Audio', 'qeducato' ),
        'post_types' => 'post',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Audio', 'qeducato' ),
                'desc'  => esc_html__( 'Soundcloud Embed Ifram Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_audio',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
        )
    );
	


      $meta_boxes[] = array(
        'id'         => 'Banner',
        'title'      => esc_html__( 'Banner Img', 'qeducato' ),
        'post_types' => 'portfolio',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Banner Img', 'qeducato' ),
                'desc'  => esc_html__( 'Banner Img Text Here', 'qeducato' ),
                'id'    => $prefix . 'post_banner',
                 'type'    => 'image_advanced',
            ),
        )
    );
	
	$meta_boxes[] = array(
        'id'         => 'team-postions-sections',
        'title'      => esc_html__( 'Team Post', 'qeducato' ),
        'post_types' => 'team',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(    
             array(
                'name'  => esc_html__( 'Feature Image', 'qeducato' ),
                'desc'  => esc_html__( 'Feature Image Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_featureimg',
                'type'  => 'image_advanced',

				// Input size
				'size'  => 30,
            ),
			 array(
                'name'  => esc_html__( 'Team Post', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_team_postions',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
        )
    );
    
    $meta_boxes[] = array(
        'id'         => 'team-social-sections',
        'title'      => esc_html__( 'Team Social Icons', 'qeducato' ),
        'post_types' => 'team',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Team Social', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_social',
                'type'  => 'textarea',

				// Input size
				'size'  => 50,
            ),
        )
    );
    
    $meta_boxes[] = array(
        'id'         => 'team-social-single-sections',
        'title'      => esc_html__( 'Team Social Single Icons', 'qeducato' ),
        'post_types' => 'team',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Team Social', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_single_social',
                'type'  => 'textarea',

				// Input size
				'size'  => 50,
            ),
        )
    );
    
    $meta_boxes[] = array(
        'id'         => 'service-icon-single-sections',
        'title'      => esc_html__( 'Team Social Single Icons', 'qeducato' ),
        'post_types' => 'service',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(          
			 array(
                'name'  => esc_html__( 'Service Icon', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_single_sicon',
                'type'  => 'textarea',

				// Input size
				'size'  => 50,
            ),
        )
    );
    
    
    $meta_boxes[] = array(
        'id'         => 'course-feature-sections',
        'title'      => esc_html__( 'Course Feature', 'qeducato' ),
        'post_types' => 'courses',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(    
            array(
                'name'  => esc_html__( 'Course Icon', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_courseicon',
                'type'  => 'image_advanced',

				// Input size
				'size'  => 30,
            ),
            array(
                'name'  => esc_html__( 'Teacher Avatar', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_teacherimg',
                'type'  => 'image_advanced',

				// Input size
				'size'  => 30,
            ),
             array(
                'name'  => esc_html__( 'Teacher Name', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_teachername',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
              array(
                'name'  => esc_html__( 'Teacher Position', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_teacherposition',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
             array(
                'name'  => esc_html__( 'Course Name', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_coursename',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
             array(
                'name'  => esc_html__( 'Course Category', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_coursecategory',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
            
			 array(
                'name'  => esc_html__( 'Course Feature Title', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_coursefeaturetitle',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
            array(
                'name'  => esc_html__( 'Course Price', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_courseprice',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
            array(
                'name'  => esc_html__( 'Discount Price', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_discountprice',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
             array(
                'name'  => esc_html__( 'Discount percentage', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_discountpercentage',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
            array(
                'name'  => esc_html__( 'Instructor', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_instructor',
                'type'  => 'textarea',

				// Input size
				'size'  => 30,
            ),
            array(
                'name'  => esc_html__( 'Lectures', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_lectures',
                'type'  => 'textarea',

				// Input size
				'size'  => 30,
            ),
            
              array(
                'name'  => esc_html__( 'Duration', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_duration',
                'type'  => 'textarea',

				// Input size
				'size'  => 30,
            ),
            array(
                'name'  => esc_html__( 'Enrolled', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_enrolled',
                'type'  => 'textarea',

				// Input size
				'size'  => 30,
            ),
            
             array(
                'name'  => esc_html__( 'Language', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_language',
                'type'  => 'textarea',

				// Input size
				'size'  => 30,
            ),
           
            
            
             array(
                'name'  => esc_html__( 'Enrollment Course Button', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_enrollcourse',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
            
             array(
                'name'  => esc_html__( 'Enroll Course URL', 'qeducato' ),
                'desc'  => esc_html__( 'URL Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_enrollcourseurl',
                'type'  => 'URL',

				// Input size
				'size'  => 30,
            ),
            
            
        )
    );
    
    
     $meta_boxes[] = array(
        'id'         => 'course-feature-sections',
        'title'      => esc_html__( 'Course Feature', 'qeducato' ),
        'post_types' => 'kidscourses',
        'context'    => 'normal',
        'priority'   => 'high',
         
        'fields' => array(
             array(
                'name'  => esc_html__( 'Age Text', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_agetext',
                'type'  => 'textarea',

				// Input size
				'size'  => 30,
            ),
            array(
                'name'  => esc_html__( 'Time Text', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_timetext',
                'type'  => 'textarea',

				// Input size
				'size'  => 30,
            ),
             array(
                'name'  => esc_html__( 'Class Size Text', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_classsizetext',
                'type'  => 'textarea',

				// Input size
				'size'  => 30,
            ),
              array(
                'name'  => esc_html__( 'fee Text', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_feetext',
                'type'  => 'textarea',

				// Input size
				'size'  => 30,
            ),
            array(
                'name'  => esc_html__( 'Course Icon', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_courseicon',
                'type'  => 'image_advanced',

				// Input size
				'size'  => 30,
            ),
            array(
                'name'  => esc_html__( 'Teacher Avatar', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_teacherimg',
                'type'  => 'image_advanced',

				// Input size
				'size'  => 30,
            ),
             array(
                'name'  => esc_html__( 'Teacher Name', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_teachername',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
              array(
                'name'  => esc_html__( 'Teacher Position', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_teacherposition',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
             array(
                'name'  => esc_html__( 'Course Name', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_coursename',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
             array(
                'name'  => esc_html__( 'Course Category', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_coursecategory',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
            
			 array(
                'name'  => esc_html__( 'Course Feature Title', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_coursefeaturetitle',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
            array(
                'name'  => esc_html__( 'Course Price', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_courseprice',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
            array(
                'name'  => esc_html__( 'Discount Price', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_discountprice',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
             array(
                'name'  => esc_html__( 'Discount percentage', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_discountpercentage',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
            array(
                'name'  => esc_html__( 'Instructor', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_instructor',
                'type'  => 'textarea',

				// Input size
				'size'  => 30,
            ),
            array(
                'name'  => esc_html__( 'Lectures', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_lectures',
                'type'  => 'textarea',

				// Input size
				'size'  => 30,
            ),
            
              array(
                'name'  => esc_html__( 'Duration', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_duration',
                'type'  => 'textarea',

				// Input size
				'size'  => 30,
            ),
            array(
                'name'  => esc_html__( 'Enrolled', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_enrolled',
                'type'  => 'textarea',

				// Input size
				'size'  => 30,
            ),
            
             array(
                'name'  => esc_html__( 'Language', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_language',
                'type'  => 'textarea',

				// Input size
				'size'  => 30,
            ),
           
            
            
             array(
                'name'  => esc_html__( 'Enrollment Course Button', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_enrollcourse',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
            
             array(
                'name'  => esc_html__( 'Enroll Course URL', 'qeducato' ),
                'desc'  => esc_html__( 'URL Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_enrollcourseurl',
                'type'  => 'URL',

				// Input size
				'size'  => 30,
            ),
            
            
        )
    );
    
    
    
     $meta_boxes[] = array(
        'id'         => 'event-date-feature',
        'title'      => esc_html__( 'Event Date Box', 'qeducato' ),
        'post_types' => 'events',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array( 
           
             array(
                'name'  => esc_html__( 'Feature Image', 'qeducato' ),
                'desc'  => esc_html__( 'Feature Image Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_featureimg',
                'type'  => 'image_advanced',

				// Input size
				'size'  => 30,
            ),
            array(
                'name'  => esc_html__( 'Event Date', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_eventdate',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
            
             array(
                'name'  => esc_html__( 'Event Month & Year', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_monthyear',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
            
             array(
                'name'  => esc_html__( 'Description', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_describe',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
        )
     );
    
    
    $meta_boxes[] = array(
        'id'         => 'event-feature-sections',
        'title'      => esc_html__( 'Event Features Sidebar', 'qeducato' ),
        'post_types' => 'events',
        'context'    => 'normal',
        'priority'   => 'high',

        'fields' => array(  
            array(
                'name'  => esc_html__( 'Event Feature Title', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_eventfeaturetitle',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
            
         		
            
            array(
                'name'  => esc_html__( 'Start Date', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),  
                'id'    => $prefix . 'post_startdate',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
            
            
            
            
            array(
                'name'  => esc_html__( 'Time', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_time',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
            
              
            array(
                'name'  => esc_html__( 'Place', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_place',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
            
            array(
                'name'  => esc_html__( 'Phone Number', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_phonenumber',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
            
             
            array(
                'name'  => esc_html__( 'Email Address', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_emailaddress',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
            
           
             array(
                'name'  => esc_html__( 'Buy Ticket', 'qeducato' ),
                'desc'  => esc_html__( 'Text Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_buyticket',
                'type'  => 'text',

				// Input size
				'size'  => 30,
            ),
            
            array(
                'name'  => esc_html__( 'Buy Ticket URL', 'qeducato' ),
                'desc'  => esc_html__( 'URL Add Here', 'qeducato' ),
                'id'    => $prefix . 'post_buyticketurl',
                'type'  => 'URL',

				// Input size
				'size'  => 30,
            ),
            
         
            
        )
    );
    
   
    // Add more meta boxes if you want
    // $meta_boxes[] = ...

    return $meta_boxes;
}