<?php
/**
 * The template for displaying service pages
 *
 * @package qeducato
 */

get_header(); 
?>

<?php get_template_part('template-parts/breadcrumbs/page-single-breadcrumbs'); ?>
<!-- Project Detail -->
<section class="project-detail">
    <div class="container">
        <!-- Upper Box -->
        <div class="upper-box">
            <div class="single-item-carousel owl-carousel owl-theme">
                <figure class="image"> <?php the_post_thumbnail(); ?></figure>                    
            </div>
        </div>

        <!-- Lower Content -->
        <div class="lower-content2">
            <div class="row">
                <div class="text-column col-lg-9 col-md-12 col-sm-12">
                    <div class="s-about-content wow fadeInRight" data-animation="fadeInRight" data-delay=".2s">  
                     <?php echo the_content();?>
                    </div>
                </div>

                <div class="info-column col-lg-3 col-md-12 col-sm-12">
                    <div class="inner-column2">
                        <h3> <?php $eventfeaturetitle = rwmb_meta( 'qeducatozc_post_eventfeaturetitle' ); echo esc_html ($eventfeaturetitle);?>            </h3>
                        <ul class="project-info clearfix">
                            <li>
                                <span class="icon fal fa-clock"></span>
                                <strong> <?php $time = rwmb_meta( 'qeducatozc_post_time' ); echo esc_html ($time);?>  </strong>
                            </li>

                            <li>
                                <span class="icon fal fa-calendar-alt"></span>
                                <strong><?php $startdate = rwmb_meta( 'qeducatozc_post_startdate' ); echo esc_html ($startdate);?> </strong>
                            </li>

                            <li>
                                <span class="icon fal fa-map-marker-check"></span>
                                <strong><?php $place = rwmb_meta( 'qeducatozc_post_place' ); echo esc_html ($place);?></strong>
                            </li>

                            <li>
                                <span class="icon fal fa-envelope"></span>
                                <strong> <?php $emailaddress = rwmb_meta( 'qeducatozc_post_emailaddress' ); echo esc_html ($emailaddress);?></strong>
                            </li>

                            <li>
                                <span class="icon fal fa-phone"></span>
                                <strong><?php $phonenumber = rwmb_meta( 'qeducatozc_post_phonenumber' ); echo esc_html ($phonenumber);?></strong>
                            </li>
                            <li>
                                <div class="slider-btn">                                          
                                     <a href="<?php $buyticketurl = rwmb_meta( 'qeducatozc_post_buyticketurl' ); echo esc_html ($buyticketurl);?>" class="btn ss-btn smoth-scroll"><?php $buyticket = rwmb_meta( 'qeducatozc_post_buyticket' ); echo esc_html ($buyticket);?> <i class="fal fa-long-arrow-right"></i></a>				
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

    </div>
</section>
<!--End Project Detail -->

<?php get_footer() ?>