<?php
/**
 * The template for displaying service pages
 *
 * @package qeducato
 */

get_header(); 
?> <?php get_template_part('template-parts/breadcrumbs/page-single-breadcrumbs'); ?>
<!-- Project Detail -->
<section class="project-detail">
  <div class="container">
    <!-- Lower Content -->
    <div class="lower-content">
      <div class="row">
        <div class="text-column col-lg-9 col-md-9 col-sm-12">
          <div class="upper-box">
            <div class="single-item-carousel owl-carousel owl-theme">
              <figure class="image"> <?php the_post_thumbnail();?> </figure>
            </div>
          </div>
          <div class="inner-column">
            <div class="course-meta2 review style2 clearfix mb-30">
              <ul class="left">
                <li>
                  <div class="author">
                    <div class="thumb"> 
                        <?php
                            $images = rwmb_meta( 'qeducatozc_post_teacherimg', array() );
                                foreach ( $images as $image ) {
                                    echo '
                            <img src="', $image['url'], '" alt="', $image['url'], '">';
                                }
                                ?> 
                      </div>
                    <div class="text">
                      <span> <?php $teachername = rwmb_meta( 'qeducatozc_post_teachername' ); echo esc_html ($teachername);?> </span>
                      <p> <?php $teacherposition = rwmb_meta( 'qeducatozc_post_teacherposition' ); echo esc_html ($teacherposition);?> </p>
                    </div>
                  </div>
                </li>
                <li class="categories">
                  <div class="author">
                    <div class="text">
                      <span> <?php $coursename = rwmb_meta( 'qeducatozc_post_coursename' ); echo esc_html ($coursename);?> </span>
                      <p> <?php $caty = rwmb_meta( 'qeducatozc_post_coursecategory' ); echo esc_html ($caty);?> </p>
                    </div>
                  </div>
                </li>
              </ul>
              <ul class="right">
                <li class="price"> <?php $price = rwmb_meta( 'qeducatozc_post_courseprice' ); echo esc_html ($price);?> </li>
              </ul>
            </div> <?php echo the_content();?>
          </div>
        </div>
        <div class="col-lg-3">
          <aside class="sidebar-widget info-column">
            <div class="inner-column3">
              <h3> <?php $quote = rwmb_meta( 'qeducatozc_post_coursefeaturetitle' ); echo esc_html ($quote);?> </h3>
              <ul class="project-info clearfix">
                <li>
                  <div class="priceing">
                    <strong> <?php $price = rwmb_meta( 'qeducatozc_post_courseprice' ); echo esc_html ($price);?> </strong>
                    <sub> <?php $discountprice = rwmb_meta( 'qeducatozc_post_discountprice' ); echo esc_html ($discountprice);?> </sub>
                    <span class="discont"> <?php $discountpercentage = rwmb_meta( 'qeducatozc_post_discountpercentage' ); echo esc_html ($discountpercentage);?> </span>
                  </div>
                </li>
                <li>
                  <span class="icon fal fa-home-lg-alt"></span> <?php $instructor = rwmb_meta( 'qeducatozc_post_instructor' ); echo html_entity_decode ($instructor);?>
                </li>
                <li>
                  <span class="icon fal fa-book"></span> <?php $lectures = rwmb_meta( 'qeducatozc_post_lectures' ); echo html_entity_decode ($lectures);?>
                </li>
                <li>
                  <span class="icon fal fa-clock"></span> <?php $duration = rwmb_meta( 'qeducatozc_post_duration' ); echo html_entity_decode ($duration);?>
                </li>
                <li>
                  <span class="icon fal fa-user"></span> <?php $enrolled = rwmb_meta( 'qeducatozc_post_enrolled' ); echo html_entity_decode ($enrolled);?>
                </li>
                <li>
                  <span class="icon fal fa-globe"></span> <?php $language = rwmb_meta( 'qeducatozc_post_language' ); echo html_entity_decode ($language);?>
                </li>
                <li>
                  <div class="slider-btn">
                    <a href="<?php $enrollcourseurl = rwmb_meta( 'qeducatozc_post_enrollcourseurl' ); echo esc_html ($enrollcourseurl);?>" class="btn ss-btn smoth-scroll"> <?php $enrollcourse = rwmb_meta( 'qeducatozc_post_enrollcourse' ); echo esc_html ($enrollcourse);?> <i class="fal fa-long-arrow-right"></i>
                    </a>
                  </div>
                </li>
              </ul>
            </div>
          </aside>
        </div>
      </div>
    </div>
  </div>
</section>
<!--End Project Detail --> <?php get_footer() ?>